/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.mbari.util.StringUtil;
import org.mbari.util.TimeUtil;

public class OasisPco2Reader {
    private File file;
    private HashMap hm;
    private static final int MIN_NUM_COLUMNS = 6;
    public static final String[] COLUMNS;
    public static final String[] UNITS;
    public static final String[] LONG_NAME;

    public OasisPco2Reader(String file) throws IOException {
        this(new File(file));
    }

    public OasisPco2Reader(File file) throws IOException {
        this.file = file;
        this.read();
    }

    public double[] get(String key) throws IllegalArgumentException {
        if (!this.hm.containsKey(key = key.toLowerCase())) {
            throw new IllegalArgumentException("The specified type was not found");
        }
        ArrayList a = (ArrayList)this.hm.get(key);
        Object[] o = a.toArray();
        double[] data = new double[o.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Double)o[i];
        }
        return data;
    }

    public double[] getTime() throws IllegalArgumentException {
        String key = "time_d";
        return this.get(key);
    }

    public double[] getTime(String type) throws IllegalArgumentException {
        String key = "time_".concat(String.valueOf(String.valueOf(type)));
        return this.get(key);
    }

    public double[] getPco2() throws IllegalArgumentException {
        String key = "pco2_d";
        return this.get(key);
    }

    public double[] getPco2(String type) throws IllegalArgumentException {
        String key = "pco2".concat(String.valueOf(String.valueOf(type)));
        return this.get(key);
    }

    public double[] getMillivolts() throws IllegalArgumentException {
        String key = "mv_d";
        return this.get(key);
    }

    public double[] getMillivolts(String type) throws IllegalArgumentException {
        String key = "mv".concat(String.valueOf(String.valueOf(type)));
        return this.get(key);
    }

    public double[] getTemperature() throws IllegalArgumentException {
        String key = "temp_d";
        return this.get(key);
    }

    public double[] getTemperature(String type) throws IllegalArgumentException {
        String key = "temp".concat(String.valueOf(String.valueOf(type)));
        return this.get(key);
    }

    public double[] getPressure() throws IllegalArgumentException {
        String key = "pressure_d";
        return this.get(key);
    }

    public double[] getPressure(String type) throws IllegalArgumentException {
        String key = "pressure".concat(String.valueOf(String.valueOf(type)));
        return this.get(key);
    }

    public Set getTypes() {
        return this.hm.keySet();
    }

    private void read() throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        this.hm = new HashMap();
        while ((line = in.readLine()) != null) {
            String keyTime;
            StringTokenizer st;
            int NumOfCol;
            if (line.startsWith("#") || line.startsWith("%") || (NumOfCol = (st = new StringTokenizer(line)).countTokens()) < 6) continue;
            String key = StringUtil.getToken(line, 6);
            if (key.length() > 1) {
                key = "D";
            }
            if (!this.hm.containsKey(keyTime = "time_".concat(String.valueOf(String.valueOf(key.toLowerCase()))))) {
                this.hm.put(keyTime, new ArrayList());
            }
            double dayOfYear = new Double(st.nextToken());
            double year = new Double(StringUtil.getToken(line, NumOfCol));
            Double time = new Double(TimeUtil.dayOfYearToDate(dayOfYear, year).getTime());
            ArrayList a = (ArrayList)this.hm.get(keyTime);
            a.add(time);
            for (int i = 0; i < COLUMNS.length; ++i) {
                Double tempVar;
                String tempKey = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(COLUMNS[i]))).append("_").append(key.toLowerCase())));
                if (!this.hm.containsKey(tempKey)) {
                    this.hm.put(tempKey, new ArrayList());
                }
                try {
                    tempVar = new Double(st.nextToken());
                }
                catch (NumberFormatException e) {
                    tempVar = new Double(Double.NaN);
                }
                a = (ArrayList)this.hm.get(tempKey);
                a.add(tempVar);
            }
        }
    }

    public static void test() {
        try {
            OasisPco2Reader r = new OasisPco2Reader("g:/m1/data/pco2");
            Set set = r.getTypes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    static {
        MIN_NUM_COLUMNS = 6;
        COLUMNS = new String[]{"pco2", "mv", "temp", "pressure"};
        UNITS = new String[]{"parts per million", "millivolts", "degrees Celsius", "kilopascals"};
        LONG_NAME = new String[]{"pCO2", "sensor output voltage", "sensor internal temperature", "sensor internal pressure"};
    }
}

