/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class HRCalibrationFileReader {
    private File calfile;
    private double[] A = new double[3];
    private double[] B = new double[3];
    private double[] C = new double[3];
    private double[] D = new double[3];
    private String serialNumber;

    public HRCalibrationFileReader(File calfile) throws IOException {
        this.calfile = calfile;
        this.read();
    }

    public HRCalibrationFileReader(String calfile) throws IOException {
        this(new File(calfile));
    }

    private void read() throws IOException {
        String calString = null;
        BufferedReader cal = new BufferedReader(new FileReader(this.calfile));
        while ((calString = cal.readLine()) != null) {
            if (calString.trim().equals("[ID]")) {
                this.serialNumber = cal.readLine().trim();
                continue;
            }
            if (calString.trim().equals("[A WAVE]")) {
                this.A[0] = Double.parseDouble(cal.readLine());
                this.A[1] = Double.parseDouble(cal.readLine());
                this.A[2] = Double.parseDouble(cal.readLine());
                continue;
            }
            if (calString.trim().equals("[B WAVE]")) {
                this.B[0] = Double.parseDouble(cal.readLine());
                this.B[1] = Double.parseDouble(cal.readLine());
                this.B[2] = Double.parseDouble(cal.readLine());
                continue;
            }
            if (calString.trim().equals("[C WAVE]")) {
                this.C[0] = Double.parseDouble(cal.readLine());
                this.C[1] = Double.parseDouble(cal.readLine());
                this.C[2] = Double.parseDouble(cal.readLine());
                continue;
            }
            if (!calString.trim().equals("[D WAVE]")) continue;
            this.D[0] = Double.parseDouble(cal.readLine());
            this.D[1] = Double.parseDouble(cal.readLine());
            this.D[2] = Double.parseDouble(cal.readLine());
        }
        if (this.serialNumber == null || this.A[0] == 0.0 || this.A[1] == 0.0 || this.A[2] == 0.0) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.calfile.getCanonicalPath()))).append(" is not a valid ").append("calibration file"))));
        }
        cal.close();
    }

    public double[] getAWave() {
        return this.A;
    }

    public double[] getBWave() {
        return this.B;
    }

    public double[] getCWave() {
        return this.C;
    }

    public double[] getDWave() {
        return this.D;
    }

    public double[] getWave(int channel) throws IllegalArgumentException {
        double[] W;
        switch (channel) {
            case 1: {
                W = this.getAWave();
                break;
            }
            case 2: {
                W = this.getBWave();
                break;
            }
            case 3: {
                W = this.getCWave();
                break;
            }
            case 4: {
                W = this.getDWave();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("'").append(channel).append("' is not a valid channel.").append("Valid channels are A,B,C,D or 1,2,3,4."))));
            }
        }
        return W;
    }

    public double[] getWave(String channel) throws IllegalArgumentException {
        int i;
        if (channel.toLowerCase().equals("a") | channel.equals("1")) {
            i = 1;
        } else if (channel.toLowerCase().equals("b") | channel.equals("2")) {
            i = 2;
        } else if (channel.toLowerCase().equals("c") | channel.equals("3")) {
            i = 3;
        } else if (channel.toLowerCase().equals("d") | channel.equals("4")) {
            i = 4;
        } else {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("'").append(channel).append("' is not a valid channel.").append("Valid channels are A,B,C,D or 1,2,3,4."))));
        }
        return this.getWave(i);
    }

    public String getID() {
        return this.serialNumber;
    }
}

