/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.hobilabs;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.mbari.hobilabs.HRPacket;

public class HRParser {
    private DataInputStream in;
    private ArrayList storage;

    public HRParser(InputStream in) throws IOException {
        this(new DataInputStream(in));
    }

    public HRParser(DataInputStream in) throws IOException {
        this.in = in;
        this.storage = new ArrayList();
    }

    public void parseFile() throws IOException {
        this.parse();
    }

    public void parse() throws IOException {
        try {
            while (true) {
                int taste;
                if ((taste = this.in.readByte()) != 15 || (taste = this.in.readUnsignedByte()) != 240) {
                    continue;
                }
                this.parsePacket();
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void parsePacket() throws IOException {
        HRPacket tmp = new HRPacket();
        tmp.RawTime = this.in.readInt();
        tmp.Temp = this.in.readFloat();
        tmp.Voltage = this.in.readFloat();
        tmp.Depth = this.in.readFloat();
        tmp.Process = this.in.readShort();
        tmp.N = this.in.readShort();
        tmp.Scale = this.in.readFloat();
        tmp.Do = this.in.readFloat();
        tmp.Dt = this.in.readFloat();
        tmp.IntTime = this.in.readInt();
        tmp.FirstPix = this.in.readShort();
        tmp.PixInc = this.in.readShort();
        tmp.PixCount = this.in.readShort();
        tmp.Pixel = new double[tmp.PixCount];
        for (int i = 0; i < tmp.PixCount; ++i) {
            tmp.Pixel[i] = tmp.Process == 0 ? (double)this.in.readShort() : (double)this.in.readFloat();
        }
        if (tmp.PixCount != 0) {
            this.storage.add(tmp);
        }
    }

    public HRPacket[] get() {
        Object[] buf = this.storage.toArray();
        HRPacket[] out = new HRPacket[buf.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (HRPacket)buf[i];
        }
        return out;
    }
}

