/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.hobilabs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import org.mbari.hobilabs.HRBinaryDecoder;
import org.mbari.hobilabs.HRPacket;
import org.mbari.io.HRCalFileNameFilter;
import org.mbari.io.HRCalibrationFileReader;
import org.mbari.util.GmtCalendar;
import org.mbari.util.HRUtil;
import ucar.multiarray.ArrayMultiArray;
import ucar.multiarray.MultiArray;
import ucar.netcdf.Attribute;
import ucar.netcdf.Dimension;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Schema;
import ucar.netcdf.UnlimitedDimension;
import ucar.netcdf.Variable;

public class HRMain {
    File calDirectory;
    File infile;
    String outfile;

    public HRMain(File calDirectory, File infile, String outfile) {
        this.calDirectory = calDirectory;
        this.infile = infile;
        this.outfile = outfile;
    }

    public HRMain(String calDirectory, String infile, String outfile) {
        this(new File(calDirectory), new File(infile), outfile);
    }

    public void process() throws IllegalArgumentException, IOException {
        if (!this.calDirectory.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(this.calDirectory.getCanonicalPath())).concat(" is not a directory."));
        }
        HRBinaryDecoder d = new HRBinaryDecoder(this.infile, false);
        d.decode();
        HRPacket[] data = d.getData();
        String[] serialNumber = d.getSerialNumbers();
        String dataDescription = d.getDataDescription();
        StringTokenizer st = new StringTokenizer(dataDescription, ",");
        String channelS = st.nextToken();
        String dataType = st.nextToken();
        String dataUnits = st.nextToken();
        StringTokenizer st2 = new StringTokenizer(channelS);
        String channel = st2.nextToken();
        channel = st2.nextToken().trim();
        String instrumentType = d.getInstrumentType();
        Object[] calList = this.calDirectory.list(new HRCalFileNameFilter(instrumentType.toLowerCase(), serialNumber[0]));
        Arrays.sort(calList);
        HRCalibrationFileReader[] calFiles = new HRCalibrationFileReader[calList.length];
        double[] calTime = new double[calList.length];
        for (int i = 0; i < calList.length; ++i) {
            calFiles[i] = new HRCalibrationFileReader(new File(this.calDirectory, (String)calList[i]));
            StringTokenizer st3 = new StringTokenizer((String)calList[i], ".");
            String tmp = st3.nextToken();
            tmp = st3.nextToken();
            tmp = st3.nextToken();
            int year = Integer.parseInt(tmp.substring(0, 4));
            int month = Integer.parseInt(tmp.substring(4, 6));
            int date = Integer.parseInt(tmp.substring(6, 8));
            calTime[i] = new GmtCalendar(year, month, date).getTime().getTime() / (long)1000;
        }
        int good = 0;
        if ((double)data[0].RawTime < calTime[0]) {
            good = 0;
        } else if ((double)data[0].RawTime > calTime[calTime.length - 1]) {
            good = calTime.length - 1;
        } else {
            for (int i = 0; i < calTime.length - 1; ++i) {
                if (!((double)data[0].RawTime >= calTime[i]) || !((double)data[0].RawTime < calTime[i + 1])) continue;
                good = i;
                break;
            }
        }
        UnlimitedDimension timeD = new UnlimitedDimension("time");
        Dimension lambdaD = new Dimension("wavelength", data[0].PixCount);
        Attribute[] globalAtt = new Attribute[]{new Attribute("conventions", "MBARI/timeSeries/mooring/hydrorad"), new Attribute("creationDate", new Date().toString()), new Attribute("lastModified", new Date().toString()), new Attribute("mooring", "M1"), new Attribute("project", "Monterey Bay Time Series"), new Attribute("keywords", "spectroradiometer"), new Attribute("instrumentType", "Hobilabs ".concat(String.valueOf(String.valueOf(instrumentType)))), new Attribute("serialNumber", serialNumber[0]), new Attribute("configurationFile", (String)calList[good]), new Attribute("sourceFile", this.infile.getName()), new Attribute("contents", dataDescription)};
        Attribute[] lambdaA = new Attribute[]{new Attribute("long_name", "wavelength"), new Attribute("units", "nanometers")};
        ProtoVariable lambdaV = new ProtoVariable("wavelength", Float.TYPE, new Dimension[]{lambdaD}, lambdaA);
        Attribute[] timeA = new Attribute[]{new Attribute("long_name", "time GMT"), new Attribute("units", "seconds since 1970-01-01 00:00:00")};
        ProtoVariable timeV = new ProtoVariable("time", Double.TYPE, new Dimension[]{timeD}, timeA);
        ProtoVariable tempV = new ProtoVariable("temp", Float.TYPE, new Dimension[]{timeD}, new Attribute[]{new Attribute("long_name", "temperature"), new Attribute("units", "celsius"), new Attribute("symbol", "T"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
        ProtoVariable voltV = new ProtoVariable("voltage", Float.TYPE, new Dimension[]{timeD}, new Attribute[]{new Attribute("long_name", "power supply voltage"), new Attribute("units", "volts"), new Attribute("symbol", "V"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
        ProtoVariable depthV = new ProtoVariable("depth", Float.TYPE, new Dimension[]{timeD}, new Attribute[]{new Attribute("long_name", "sensor depth"), new Attribute("units", "unknown"), new Attribute("symbol", "Z"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
        ProtoVariable intV = new ProtoVariable("intTime", Float.TYPE, new Dimension[]{timeD}, new Attribute[]{new Attribute("long_name", "integration time"), new Attribute("units", "seconds"), new Attribute("symbol", "I"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
        ProtoVariable dataV = new ProtoVariable("data", Float.TYPE, new Dimension[]{timeD, lambdaD}, new Attribute[]{new Attribute("long_name", dataType), new Attribute("units", dataUnits), new Attribute("symbol", "Z"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
        Schema schema = new Schema(new ProtoVariable[]{lambdaV, timeV, tempV, voltV, depthV, intV, dataV}, globalAtt);
        NetcdfFile nc = new NetcdfFile(this.outfile, true, true, schema);
        double[] lambda = HRUtil.calcWavelength(data[0], calFiles[good].getWave(channel));
        float[] lambdaF = new float[lambda.length];
        for (int i = 0; i < lambda.length; ++i) {
            lambdaF[i] = (float)lambda[i];
        }
        double[] time = new double[data.length];
        float[] temp = new float[data.length];
        float[] voltage = new float[data.length];
        float[] depth = new float[data.length];
        float[] intT = new float[data.length];
        float[][] dat = new float[data.length][lambda.length];
        for (int r = 0; r < data.length; ++r) {
            time[r] = data[r].RawTime;
            temp[r] = (float)data[r].Temp;
            voltage[r] = (float)data[r].Voltage;
            depth[r] = (float)data[r].Depth;
            intT[r] = data[r].IntTime;
            dat[r] = new float[data[r].Pixel.length];
            for (int c = 0; c < dat[r].length; ++c) {
                dat[r][c] = (float)data[r].Pixel[c];
            }
        }
        int[] origin = new int[]{0, 0};
        ArrayMultiArray m = new ArrayMultiArray((Object)time);
        Variable v = nc.get(timeV.getName());
        v.copyin(origin, (MultiArray)m);
        m = new ArrayMultiArray((Object)dat);
        v = nc.get(dataV.getName());
        v.copyin(origin, (MultiArray)m);
        int[] origin2 = new int[]{0};
        m = new ArrayMultiArray((Object)lambdaF);
        v = nc.get(lambdaV.getName());
        v.copyin(origin2, (MultiArray)m);
        m = new ArrayMultiArray((Object)temp);
        v = nc.get(tempV.getName());
        v.copyin(origin2, (MultiArray)m);
        m = new ArrayMultiArray((Object)voltage);
        v = nc.get(voltV.getName());
        v.copyin(origin2, (MultiArray)m);
        m = new ArrayMultiArray((Object)depth);
        v = nc.get(depthV.getName());
        v.copyin(origin2, (MultiArray)m);
        m = new ArrayMultiArray((Object)intT);
        v = nc.get(intV.getName());
        v.copyin(origin2, (MultiArray)m);
        nc.close();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: java org.mbari.hobilabs.hr.HRMain <Directory containing cal files> <infile> <outfile>");
            System.exit(0);
        }
        HRMain main = new HRMain(args[0], args[1], args[2]);
        try {
            main.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

