/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.hobilabs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Date;
import org.mbari.hobilabs.HRBinaryDecoder;
import org.mbari.hobilabs.HRPacket;
import org.mbari.io.HRCalibrationFileReader;

public class HRBinaryConverter {
    File infile;
    File outfile;
    File calfile;
    String channel;

    public HRBinaryConverter(File infile, File calfile, File outfile, String channel) throws IllegalArgumentException {
        this.infile = infile;
        this.calfile = calfile;
        this.outfile = outfile;
        this.channel = channel;
    }

    public HRBinaryConverter(String infile, String calfile, String outfile, String channel) throws IllegalArgumentException {
        this(new File(infile), new File(calfile), new File(outfile), channel);
    }

    public void convert() throws IOException {
        if (!this.infile.canRead()) {
            System.err.println("Unable to read ".concat(String.valueOf(String.valueOf(this.infile.getCanonicalPath()))));
            return;
        }
        if (!this.calfile.canRead()) {
            System.err.println("Unable to read ".concat(String.valueOf(String.valueOf(this.calfile.getCanonicalPath()))));
            return;
        }
        if (this.outfile.isDirectory()) {
            throw new IOException(String.valueOf(String.valueOf(this.outfile.getCanonicalPath())).concat(" already exists as a directory."));
        }
        HRCalibrationFileReader cal = new HRCalibrationFileReader(this.calfile);
        double[] W = cal.getWave(this.channel);
        String id = cal.getID();
        HRBinaryDecoder in = new HRBinaryDecoder(this.infile, false);
        in.decode();
        HRPacket[] data = in.getData();
        String channelInfo = in.getDataDescription();
        String instrumentType = in.getInstrumentType();
        String[] sn = in.getSerialNumbers();
        String serialNumber = sn[0];
        BufferedWriter out = new BufferedWriter(new FileWriter(this.outfile));
        out.write("# Hydrorad processed data file, org.mbari.hobilabs.hr.HRBinaryDecoder v1.1\n");
        out.write(String.valueOf(String.valueOf(new StringBuffer("# File created on ").append(new Date()).append("\n#\n"))));
        out.write(String.valueOf(String.valueOf(new StringBuffer("# Instrument: ").append(instrumentType).append(", ").append(serialNumber).append("\n"))));
        out.write(String.valueOf(String.valueOf(new StringBuffer("# Source file: ").append(this.infile.getCanonicalPath()).append("\n#\n"))));
        out.write(String.valueOf(String.valueOf(new StringBuffer("# Calibration file: ").append(this.calfile.getCanonicalPath()).append("\n"))));
        if (!serialNumber.equals(id)) {
            out.write("# WARNING: The serial number in the calibration file used to process this data did not match the one in the data file!\n");
        }
        out.write(String.valueOf(String.valueOf(new StringBuffer("# This file contains: ").append(channelInfo.toString()).append("\n"))));
        out.write("# RawTime\tTemp\tVoltage\tDepth\tProcess\tN\tScale\tDo\tDt\tIntTime\tFirstPix\tPixInc\tPixCount\t");
        double firstPix = data[0].FirstPix;
        double pixInc = data[0].PixInc;
        double pixCount = data[0].PixCount;
        double pixelNum = 0.0;
        double[] lambda = new double[(int)pixCount];
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        nf.setMinimumIntegerDigits(3);
        int i = 0;
        while ((double)i < pixCount) {
            pixelNum = firstPix + pixInc * (double)i;
            lambda[i] = W[0] + W[1] * pixelNum + W[2] * pixelNum * pixelNum;
            String term = null;
            term = (double)i == pixCount - 1.0 ? "\n" : "\t";
            out.write(String.valueOf(String.valueOf(nf.format(lambda[i]))).concat(String.valueOf(String.valueOf(term))));
            ++i;
        }
        nf.setMaximumFractionDigits(10);
        nf.setMinimumFractionDigits(10);
        nf.setMinimumIntegerDigits(1);
        NumberFormat nf2 = NumberFormat.getNumberInstance();
        nf2.setMaximumFractionDigits(2);
        nf2.setMinimumFractionDigits(2);
        nf2.setMinimumIntegerDigits(1);
        for (int i2 = 0; i2 < data.length; ++i2) {
            out.write(String.valueOf(String.valueOf(data[i2].RawTime)).concat("\t"));
            out.write(String.valueOf(String.valueOf(nf2.format(data[i2].Temp))).concat("\t"));
            out.write(String.valueOf(String.valueOf(nf2.format(data[i2].Voltage))).concat("\t"));
            out.write(String.valueOf(String.valueOf(nf2.format(data[i2].Depth))).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].Process)).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].N)).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].Scale)).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].Do)).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].Dt)).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].IntTime)).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].FirstPix)).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].PixInc)).concat("\t"));
            out.write(String.valueOf(String.valueOf(data[i2].PixCount)).concat("\t"));
            for (int j = 0; j < data[i2].Pixel.length; ++j) {
                out.write(String.valueOf(String.valueOf(nf.format(data[i2].Pixel[j]))).concat("\t"));
            }
            out.newLine();
        }
        out.close();
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("\nUsage: org.mbari.hobilabs.HRBinaryConverter <input file> <calibration file>  <output file> <channel>");
            System.exit(0);
        }
        HRBinaryConverter op = new HRBinaryConverter(args[0], args[1], args[2], args[3]);
        try {
            op.convert();
        }
        catch (IOException e) {
            System.out.println(" Error: ".concat(String.valueOf(String.valueOf(e.getMessage()))));
            e.printStackTrace();
        }
    }
}

