/******************************************************************************\
**	ctrlc.c
**	
**	First release:			10/16/2001
**	Update release:			04/19/2002
*****************************************************************************
**	Developed by:	Thomas P. Sullivan
**	tpsully@persistor.com - http://www.persistor.com
**	Copyright (C) 2000-2002 Persistor Instruments Inc.	All rights reserved.
**	
*****************************************************************************
** 
** Copyright and License Information
** 
** Persistor Instruments Inc. (hereafter, PII) grants you (hereafter,
** Licensee) a non-exclusive, non-transferable license to use the software
** source code contained in this single source file with hardware products
** sold by PII. Licensee may distribute binary derivative works using this
** software and running on PII hardware products to third parties without
** fee or other restrictions.
** 
** PII MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
** SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
** IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
** OR NON-INFRINGEMENT. PII SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
** LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THE SOFTWARE OR
** ITS DERIVATIVES.
** 
** By using or copying this Software, Licensee agrees to abide by the
** copyright law and all other applicable laws of the U.S. including, but
** not limited to, export control laws, and the terms of this license. PII
** shall have the right to terminate this license immediately by written
** notice upon Licensee's breach of, or non-compliance with, any of its
** terms. Licensee may be held legally responsible for any copyright
** infringement or damages resulting from Licensee's failure to abide by
** the terms of this license. 
**	
**	
*****************************************************************************
**	
**	This program demonstrates patching the BIOS to use a substitute for
**	SCIRxFilter to intercept and act on Control-C (you could use it to watch
**	for any character or a sequence of characters.
**	
\******************************************************************************/

#include	<cfxbios.h>		// Persistor BIOS and I/O Definitions
#include	<cfxpico.h>		// Persistor PicoDOS Definitions

#include	<assert.h>
#include	<ctype.h>
#include	<errno.h>
#include	<float.h>
#include	<limits.h>
#include	<locale.h>
#include	<math.h>
#include	<setjmp.h>
#include	<signal.h>
#include	<stdarg.h>
#include	<stddef.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>

#include	<dirent.h>		// PicoDOS POSIX-like Directory Access Defines
#include	<dosdrive.h>	// PicoDOS DOS Drive and Directory Definitions
#include	<fcntl.h>		// PicoDOS POSIX-like File Access Definitions
#include	<stat.h>		// PicoDOS POSIX-like File Status Definitions
#include	<termios.h>		// PicoDOS POSIX-like Terminal I/O Definitions
#include	<unistd.h>		// PicoDOS POSIX-like UNIX Function Definitions

#define	CONTROL_C	0x03

bool bFlag = false;

//	Our patch (alternate) for SCIRxFilter
ushort	SCIRxFilter_P1(ushort data:__d0):__d0;
ushort	SCIRxFilter_P1(ushort data:__d0):__d0
{
	if(data == CONTROL_C)
		bFlag = true;
	return data;
}

/******************************************************************************\
**	main
\******************************************************************************/
int main(int argc, char **argv)
	{
	short	i;
	short	result = 0;		// no errors so far

	// Identify the progam and build
	printf("\nProgram: %s: %s %s \n", __FILE__, __DATE__, __TIME__);
	// Identify the device and its firmware
	printf("Persistor CF%d SN:%ld   BIOS:%d.%d   PicoDOS:%d.%d\n", CFX,
		BIOSGVT.CFxSerNum, BIOSGVT.BIOSVersion, BIOSGVT.BIOSRelease, 
		BIOSGVT.PICOVersion, BIOSGVT.PICORelease);
	// Identify the arguments
	printf("\n%d Arguments:\n", argc);
	for (i = 0; i < argc; i++)
		printf("  argv[%d] = \"%s\"\n", i, argv[i]);
	
	cprintf("\n\nWe'll wait until we get a break...we'd be logging here or whatever\n");
	cprintf("\nSend a break to exit or type a control-c.\n\n");

	SCIRxSetBuffered(true);	//Must be buffered for this to work!!!

	BIOSPatchInsert(SCIRxFilter, SCIRxFilter_P1);	//Apply the Patch

	while(!SCIRxBreak(2))
	{
		if(bFlag)
		{
			cprintf("Bingo!!!\n");
			bFlag = false;
			return 0;	//Or BIOSReset() or BIOSResetToPBM() or BIOSResetToPicoDOS()
		}
	}
	
	
// Various exit strategies
//	BIOSReset();			// full hardware reset
//	BIOSResetToPBM();		// full reset, but stay in Pesistor Boot Monitor
//	BIOSResetToPicoDOS();	// full reset, but jump to 0xE10000 (PicoDOS)
	return result;

	}	//____ main() ____//

