/******************************************************************************\
**	AsmSourceToCodeWarriorC.c	Conversion from asm source to MWC asm  
**	
*****************************************************************************
**	Conversion changes --jhg
**		[] to () for register offsets
**		EQUs to #defines
**		ret to rts
**		PUBLIC definitions to C asm prototypes
**		; to // line comments
**		declare register arguments in prototypes and let compiler handle
**		tst.x a? to move a?,d0; tst.x d0 (tst doesn't operate on addr regs)
**		change short forware bxx to bxx.s
**		change br to bra
**	
\******************************************************************************/

//;*****************************************************************************
//;
asm void list_init(struct LstHead *lp:__a0);	//;Init linked list
asm void list_head(struct LstHead *lp:__a1);	//;Get and remove first node of linked list
asm void list_add(struct LstHead *lp:__a1, struct Node *np:__a0);	//;Add node to end of linked list
asm struct Node *list_get(struct LstHead *lp:__a1, struct Node *np:__a0):__a0;	//;Get and remove given node from linked list
asm struct Node *list_first(struct LstHead *lp:__a1):__a0;	//;Get first node of linked list
asm struct Node *list_next(struct Node *lp:__a1):__a0;		//;Get next node of linked list


//;******************** List Head Structure *********************************
//;
#define HEAD	0		//;Pointer to first item on list
#define TAIL	4		//;Pointer to last item on list

//;******************** Node Structure *********************************
//;
#define NEXT	0		//;Pointer to next item on list
#define PREV	4		//;Pointer to previous item on list

/******************************************************************************\
; LIST_INIT - Initialize Linked List
;
; Void list_init( LstHead *lp );
;
\******************************************************************************/
asm void list_init(struct LstHead *lp:__a0)
	{
	clr.l	HEAD(a0)	// a0 passed in as register parameter
	clr.l	TAIL(a0)
	rts
	}

/******************************************************************************\
; LIST_HEAD - Delete and return head of linked list
;
; Node *list_head( LstHead *lp );
;
\******************************************************************************/
asm void list_head(struct LstHead *lp:__a1)
	{
	movea.l	HEAD(a1), a0	// a1 passed in as register parameter
	move.l	a0,d0
	tst.l	d0
	beq.s	lhret

	movea.l	NEXT(a0), a2
	move.l	a2, HEAD(a1)
	move.l	a2,d0
	tst.l	d0
	beq.s	lh2
	clr.l	PREV(a2)
	rts
lh2:
	clr.l	TAIL(a1)
lhret:
	rts
	}
	
/******************************************************************************\
; LIST_ADD - Add a node to the end of a linked list
;
; Void list_add( LstHead *lp, Node *np );
;
\******************************************************************************/
asm void list_add(struct LstHead *lp:__a1, struct Node *np:__a0)
	{
	movea.l	TAIL(a1), a2	// a1 passed in as register parameter
	clr.l	NEXT(a0)		// a0 passed in as register parameter
	move.l	a2, PREV(a0)
	move.l	a0, TAIL(a1)
	move.l	a2,d0
	tst.l	d0
	beq.s	la1
	move.l	a0, NEXT(a2)
	rts
la1:	
	move.l	a0, HEAD(a1)
	rts
	}		

/******************************************************************************\
; LIST_GET - Delete and return a given node from linked list
;
; Node *list_get( LstHead *lp, Node *np );
;
\******************************************************************************/
asm struct Node *list_get(struct LstHead *lp:__a1, struct Node *np:__a0):__a0
	{
lg1:
	movea.l	 NEXT(a0), a2
	movea.l	 PREV(a0), a3
	move.l	a3,d0
	tst.l	d0
	beq.s	lg2
	move.l	a2, NEXT(a3)
	bra.s	lg3	
lg2:	
	move.l	a2, HEAD(a1)
lg3:	
	move.l	a2,d0
	tst.l	d0
	beq.s	lg4
	move.l	a3, PREV(a2)
	rts
lg4:
	move.l	a3, TAIL(a1)
	rts
#pragma warn "I don't know what's supposed to return as Node * so I made it a0 --jhg"
	}

/******************************************************************************\
; LIST_FIRST - Return first entry of linked list
;
; Node *list_first( LstHead *lp );
;
\******************************************************************************/
asm struct Node *list_first(struct LstHead *lp:__a1):__a0
	{
	movea.l	HEAD(a1), a0	// a1 passed in as register parameter
	rts
	}

/******************************************************************************\
; LIST_NEXT - Return first entry of linked list
;
; Node *list_next( Node *np );
;
\******************************************************************************/
asm struct Node *list_next(struct Node *lp:__a1):__a0
	{
	movea.l	NEXT(a1), a0	// a1 passed in as register parameter
	rts
	}
