/****************************************************************************/
/* Copyright 1998 MBARI                                                     */
/****************************************************************************/
/* $Header: gf.c,v 2.9 98/08/24 13:46:01 bobh Exp $			    */
/* Summary  : Ground Fault decode routines for decode.c, extract.c	    */
/* Filename : gf.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 2.9 $							    */
/* Created  : 12 june 1998						    */
/****************************************************************************/
/* Modification History:						    */
/* 12jun98 rah - created						    */
/* $Log:	gf.c,v $
 * Revision 2.9  98/08/24  13:46:01  13:46:01  bobh (Bob Herlien)
 * Archiving sources after M2/M3 & Eqpac deployments of 1998
 * 
*/
/****************************************************************************/

#include <stdio.h>			/* Standard I/O			    */
#include <mbariTypes.h>			/* MBARI type definitions	    */
#include <mbariConst.h>			/* MBARI constants		    */
#include <decode.h>			/* OASIS controller definitions	    */
#include <string.h>			/* For strncpy			    */


/********************************/
/*	External Functions	*/
/********************************/

Extern Nat16	getMotword( Byte *p ); /* Get word in Motoroloa format	    */


/************************************************************************/
/* Function    : read_gf_cal						*/
/* Purpose     : Read Ground Fault calibration file			*/
/* Inputs      : Name of file, ptr to calibr struct			*/
/* Outputs     : OK or ERROR						*/
/************************************************************************/
	Status
read_gf_cal( char *fileName, GndFltCal *gfp )
{
    FILE		*fp;
    Reg Int		calNum;
    Reg GndFltCal	*gfPtr;
    Int			bufOffset;
    char		buff[256];

    for ( calNum = 0, gfPtr = gfp; calNum < MAX_GF_CALS; calNum++, gfPtr++ )
    {						/* Init cal struct	*/
	bzero( gfPtr, sizeof(GndFltCal) );
	gfPtr->cal_offset = 0.0;
	gfPtr->cal_divisor = 0.0;
	gfPtr->cal_valid = FALSE;
    }

    if ( (fp = fopen(fileName, "rb")) == (FILE *)NULL )
	return( ERROR );

    gfPtr = gfp;
    for ( calNum = 0; (calNum < MAX_GF_CALS) && 
	 (fgets(buff, sizeof(buff), fp) != NULL); )
    {
	if ( sscanf(buff, "%d %lg %lg %s%n ", &gfPtr->raw_offset,
		    &gfPtr->cal_offset, &gfPtr->cal_divisor, 
		    &gfPtr->units, &bufOffset) >= 4 )
	{
	    gfPtr->cal_valid = TRUE;
	    if ( buff[strlen(buff)-1] == '\n' )
		buff[strlen(buff)-1] = '\0';
	    strncpy( gfPtr->ident, &buff[bufOffset], GFIDENTLEN );
	    gfPtr++;
	    calNum++;
	}
    }

    fclose( fp );
    return( OK );

} /* read_gf_cal() */
