/****************************************************************************/
/* Copyright 1991 MBARI                                                     */
/****************************************************************************/
/* $Header: chktmp.c,v 1.0 92/08/06 15:28:05 hebo Exp $		*/
/* Summary  : Check Temperature Calibrations for ATLAS Thermistor Pods	    */
/* Filename : chktmp.c                                                      */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 1.0 $							*/
/* Created  : 03/21/91                                                      */
/****************************************************************************/
/* Modification History:						    */
/* $Log:	chktmp.c,v $
 * Revision 1.0  92/08/06  15:28:05  15:28:05  hebo
 * Initial revision
 * 
*/
/* 21mar91 rah - created						    */
/****************************************************************************/


#include <stdio.h>
#include <string.h>
#include <math.h>

FILE	*in[2], *cntfile;
char	buff[256];

main( argc, argv )
     int	argc;
     char	*argv[];
{
    int		i, cnt, pod1, pod2;
    double	a1, a2, b1, b2, c1, c2;
    double	r, logr, temp1, temp2;

    if ( argc < 4 )
    {
	printf("Usage: chktmp infile1 infile2 cntfile\n");
	printf("  where infile1, infile2 are names of .coef files produced ");
	printf("by calsh5\n");
	printf("  and cntfile contains the set of test counts\n");
	exit( 1 );
    }
    for ( i = 0; i < 2; i++ )
    {
	strcpy( buff, argv[i+1] );
	strcat( buff, ".coef" );
	if ((in[i] = fopen(buff, "r")) == NULL)
	{
	    printf("Could not open input file %s\n", buff);
	    exit( 1 );
	}
    }
    if ((cntfile = fopen(argv[3], "r")) == NULL)
    {
	printf("Could not open count file %s\n", argv[3]);
	exit( 1 );
    }
    printf("\n                  %10.10s         %10.10s\n", argv[1], argv[2]);
    printf("Count  Resistance  Pod    Temp        Pod    Temp\n");

    while(fscanf(in[0], "%d %s %lg %lg %lg", &pod1, buff, &a1, &b1, &c1) >= 5)
    {
	if (fscanf(in[1], "%d %s %lg %lg %lg", &pod2, buff, &a2, &b2, &c2) < 5)
	{
	    printf("No pod in %s corresponding to %d in %s\n",
		   argv[2], pod1, argv[1]);
	    exit( 1 );
	}

	rewind( cntfile );

	while( fscanf(cntfile, "%x", &cnt) >= 1 )
	{
	    r = 7.68e08 / (2.525*cnt - 7680.0);
	    logr = log10(r);
	    temp1 = 1.0 / (a1 + b1*logr + c1*logr*logr*logr) - 273.15;
	    temp2 = 1.0 / (a2 + b2*logr + c2*logr*logr*logr) - 273.15;
	    printf("%5d  %9.2f  %4d %10.5f    %4d %10.5f\n", 
		   cnt, r, pod1, temp1, pod2, temp2);
	}
	printf("\n");
    }
}
