/************************************************************************/
/* Copyright 1991 MBARI							*/
/************************************************************************/
/* Summary  : Include file of defined constants				*/
/* Filename : const.h							*/
/* Author   : Andrew Pearce, Robert Herlien				*/
/* Project  : OASIS Mooring						*/
/* Version  : 1.0							*/
/* Created  : 02/06/91							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 06feb91 rah - created from Andy's const.h (rah)			*/
/************************************************************************/

#ifndef INCconsth
#define INCconsth	1

#include <math.h>

#ifndef FALSE
#define FALSE	0
#endif

#ifndef TRUE
#define	TRUE	~FALSE
#endif

#define ON	TRUE
#define	OFF	FALSE

#define OK	 0
#define SUCCESS	 0
#define ERROR	-1

#ifndef min
#define	min(a,b)	((a) < (b) ? (a) : (b))
#endif
#ifndef max
#define max(a,b)	((a) > (b) ? (a) : (b))
#endif

#define FEET		0
#define METERS		1
#define FT_TO_M		0.3048
#define PI		3.14159265358979323846

#define	DEGTENTH 	0.00174533 /*  .1 degree in rads */
#define	DEG45		0.7854 	   /*  45 degrees in rads */
#define	DEG90		1.5707963  /*  90 degrees in rads */
#define DEG180 		PI	   /* 180 degrees in rads */
#define DEG270 		4.71238898 /* 270 degrees in rads */
#define	DEG360		6.2831853  /* 360 degrees in rads */

#define EASTING         1
#define NORTHING	2
#define LATITUDE        3
#define LONGITUDE       4
#define BEARING         5

#endif /* INCconsth */
