
/* New World Order 3/2001 (klh) */
/* ARGOS buffering re-write */

/* Legacy Defines */
Global SpecCal  spec_cal;		/* Struct to hold Spect calibrations*/
#define GMT_OFFSET (-8)
#define	CHEM_SAMPLES		 8	/* 8 samples/day for CO2, NO3, etc  */
#define CH_UNUSED_SIZE 7

#define CHEM_TIME(i)    ((Flt64)(i)/(8.0*365.0))
#define ASPEC_CHANS		 7	/* Number of channels of spectro data*/
#define DFLT_REV 5

#define CRC_MSB		0x1000		/* MSB of CRC checksum word	    */
#define CRC12		0x180f		/* CRC-12 check polynomial	    */
#define FLUOR_CHAN	0		/* Analog channel for Wetstar fluor*/
#define TEMP_CHAN	2		/* Analog channel for temperature  */
#define OBATT_CHAN	3		/* Analog channel for OASIS battery*/
#define ABATT_CHAN	6		/* Analog channel for ARGOS battery*/


/* New Defines */

#define DEBUG(x) printDebug x;          /* e.g., DEBUG(("foo %d",bar)) */

#undef _DEBUG_
#define ISUS0_BYTES 14
#define ISUS1_BYTES 14

#define DEFAULT_KEY 0

#define kMAXLINE 1024 /* Max line buffer size */
#define kMAXMESSAGES	100		/* Max messages to store & compare */

typedef enum				/********************************/
{					/* Return value from getXXXMsg	*/
    MSG_OK,				/* Successful conversion	*/
    BAD_MSG,				/* Bad message data		*/
    END_OF_FILE				/* End of input file		*/
} MsgRtn;				/********************************/

/* Buffer Enumeration */
typedef enum{
BUF0,
BUF1,
BUF2,
BUF3,
BUF4,
BUF5,
BUF6,
BUF7,
BUF8,
BUF9,
}kBUFFERTYPE;

/* Data Item Enumeration */
typedef enum{
NOTYPE=0,
_0M_OSMO_NO3,
AC9_1_DATA,
AC9_2_DATA,
AC9_TEMP,
AC9_CHLOROPHYLL,
AC9_PUMP,
PCO2_10BIT,

PCO2_12BIT,
_0M_1200_PRR620_PITCH,
_0M_1200_PRR620_ROLL,
_0M_1200_PRR600_TEMP,
_0M_1200_PRR600_DEPTH,
_0M_1230_PRR620_PITCH,
_0M_1230_PRR620_ROLL,
_0M_1230_PRR600_TEMP,
_0M_1230_PRR600_DEPTH,
_0M_ISUS_REC0_NO3,

_0M_1200_PRR620_ED,
_0M_1200_SATA_LU,
_0M_PRR_ERRCNT0,

_0M_1230_PRR620_ED,
_0M_1230_SATA_LU,
_0M_PRR_CHCNT,

_0M_1030_PRR620_ED,
_0M_1030_PRR620_LU,
_0M_1000_PRR620_ED,
_0M_ISUS_REC1_NO3,


PCO2_CAL_10BIT,
PCO2_CAL_12BIT,
OASIS_DAT,
_20M_OSMO_NO3,
_0M_WETSTAR_FLUOR,
_20M_WETSTAR_FLUOR,

_20M_1200_PRR600_ED,
_20M_1200_PRR600_LU,
_10M_1200_MCP_ED,

_20M_1230_PRR600_ED,
_20M_1230_PRR600_LU,
_20M_1000_PRR600_ED,
_20M_1000_PRR600_LU,
_30M_1200_MCP_ED,

_0M_SHUTTER_ATTEMPTS,
_0M_SHUTTER_OPENS,
_0M_SHUTTER_CLOSES,
_0M_SHUTTER_TOTALERRS,
_0M_SHUTTER_ERRTYPES,
OASIS_ERRS,
_0M_0000_SATB_LU,
_0M_1200_CTD_COND,
_0M_1200_CTD_TEMP,

_0M_1200_PRR620_LU,
_0M_0000_PRR620_ED,
_0M_0000_SATA_LU,

_20M_0000_PRR600_ED,
_20M_0000_PRR600_LU,

_0M_1200_SATB_LU,
_0M_1230_SATB_LU,
_0M_HS2_SCATTER,

}kDataItemIDs;

#define kMAXITEM   _0M_HS2_SCATTER
#define kMAXBUFFERS 10
#define kMAXKEY    5
#define KEY(p,q) (bufferMapping[p][q])
#define DAY(x)   (fileDate(x))
#define MSGTYPE(m) ((m->msg.rawb.by_data[1] >> 4) & 0x0f)

#define ARGOS_DATA_SIZE         30
#define	ARGOS_BUFFER_BYTES     	32	        /* Length of ARGOS data	    */
#define	ARGOS_BUFFER_WORDS	(ARGOS_BUFFER_BYTES/2)	/* Length of data in words  */

#define kMAXBUFFERITEMS 32
#define kMAXCONTAINER 128

/****************************************/
/* Output file identifiers		*/
/****************************************/

typedef enum				/************************************/
{					/* Output file index		    */
    ERROR_FILE = 0,			/* Errors			    */
    CO2_FILE,				/* CO2				    */
    CO2_CAL_FILE,			/* CO2 calibration records	    */
    NO3_0_FILE,				/* Surface Nitrate		    */
    NO3_20_FILE,			/* 20m Nitrate			    */
    SPEC_NOON_FILE,			/* Noon surface spectro		    */
    SPEC_1030_FILE,			/* 1030AM surface spectro	    */
    SPEC_20_FILE,			/* Noon 20m spectro		    */
    MCP_FILE,				/* Noon 20m MCP			    */
    AC9_1_FILE,				/* AC-9, first half		    */
    AC9_2_FILE,				/* AC-9, second half		    */
    TEMP0_FILE,				/* Surface temperature from NO3	    */
    TEMP20_FILE,			/* 20m temperature from NO3	    */
    OASIS_FILE,				/* OASIS battery		    */
    ARGOS_FILE,				/* Number of hits on ARGOS xmission */
    SPEC_0M_1230_FILE,			/* 1230PM surface spectro	    */
    SPEC_20M_1230_FILE,			/* 1230PM 20 meter spectro	    */
    SPEC_0M_DARK_FILE,			/* Midnight surface spectro	    */
    SPEC_20M_DARK_FILE,			/* Midnight 20 meter spectro	    */
    WETSTAR_FILE,			/* Wetstar			    */
    SHUTTER_FILE,			/* PRR Shutter			    */
    SAT1_DARK_FILE,			/* Satlantic 1 Dark file	    */
    SAT1_FILE,				/* Satlantic 1 file		    */
    SPEC_MISC_FILE,			/* Pitch, roll, temp, depth from spec*/
    SPEC_0M_1000_FILE,			/* 1000AM surface spectro	    */
    SPEC_20M_1000_FILE,			/* 1000AM 20 meter spectro	    */
    ISUS_FILE,
    HS2_FILE
} ArchiveFileType;			/************************************/

#define ARGFILES	(HS2_FILE+1)

/* Print Flags */
#define fCONSOLE 0x0001L
#define fARCHIVE 0x0002L
#define fHTML    0x0004L

/* Print Option Flags */
#define fNOOPTIONS 0x0000L

/* Containers for extracted data */
typedef struct{
  Flt64 ed[ASPEC_CHANS];
  Flt64 lu[ASPEC_CHANS];
  char isus[30];
  Nat16 err;
}CS0;

typedef struct{
  Nat16 co2[CHEM_SAMPLES];
  Nat16 co2Cal;
  Flt64 pitch1200;
  Flt64 roll1200;
  Flt64 temp1200;
  Flt64 depth1200;
  Flt64 pitch1230;
  Flt64 roll1230;
  Flt64 temp1230;
  Flt64 depth1230;
  char isus[30];
}CS1;

typedef struct{
  Flt64 co2Cal;
  Flt64 oasisBattery;
  Flt64 oasisTemp;
  Flt64 argosBattery;
  Flt64 wetstar0M[8];
  Flt64 wetstar20M[8];
}CS2;

typedef struct{
  Nat16 shutterAttempts; 
  Nat16 shutterOpens; 
  Nat16 shutterCloses; 
  Nat16 shutterTotalErrors;
  Nat16 shutterTimeouts;
  Nat16 shutterCollisions;
  Nat16 shutterRedundants;
  Nat16 oasisErrors;
  Flt64 lu[7];
  Flt64 temp;
  Flt64 cond;
}CS3;

typedef struct _CSUnion{
  CS0 cs0;
  CS1 cs1;
  CS2 cs2;
  CS3 cs3;
}CSUnion;


typedef struct{
  Word header;
  Byte data[ ARGOS_DATA_SIZE ];
}ArgosMsg;

typedef struct				/************************************/
{					/* ARGOS message as array of bytes  */
    Byte	by_data[ARGOS_BUFFER_BYTES];	/* Data				    */
} ByteMsg;				/************************************/

typedef struct				/************************************/
{					/* ARGOS message as array of words  */
    Nat16  wd_data[ARGOS_BUFFER_WORDS];	/* Data				    */
} WordMsg;				/************************************/

typedef union				/************************************/
{					/* Union of all ARGOS Message types */
    ByteMsg	rawb;			/* Raw byte format		    */
    WordMsg	raww;			/* Raw word format		    */
    ArgosMsg    hd;                     /* General header/data format       */
}ArgosUnion;

typedef struct				/************************************/
{					/* Struct to hold incoming msgs	    */
    time_t	first_msg;		/* First time msg was sent	    */
    time_t	last_msg;		/* Last time msg was sent	    */
    Nat32	msg_cnt;		/* Number of times msg was sent	    */
    Int32	printed;		/* Boolean to say we printed it	    */
    ArgosUnion	msg;			/* Message			    */
} ArgosInMsg;				/************************************/


typedef struct _ItemInfo{
  Nat32 id;
  int offset;
  int len;
  Byte *pData;
  void (*pExFunc)( ArgosInMsg *pMsg, struct _ItemInfo *pItem, Nat32 key);
  void (*pPrFunc)(struct _ItemInfo *pItem, Nat32 oflags, Nat32 options);
}ItemInfo;

typedef struct _BufferMap{
  void (*pPrFunc)(ArgosInMsg *pMsg, struct _BufferMap *pMap, Nat32 oflags, Nat32 options);
  ItemInfo item[kMAXBUFFERITEMS];
}BufferMap;


typedef struct{
 Nat16 address;
 Nat16 channel;
}SpecAddr;

typedef struct{
  Int32 id;
  SpecAddr data[kMAXKEY];
}eSpecInfo;
