/*									    */
/* $Header: jday.c,v 1.2 2001/06/19 13:23:52 oasisa Exp $ */
/* Copyright 2001 MBARI                                                     */
/* Author: Kent Headley                                                     */
/* $Revision: 1.2 $ */
/* Summary: Compute day of year                                             */
/* Input: 0 or more dates mm/dd/yyyy; Default is current day                */
/* Output: Day of year                                                      */
/* Notes: Compile with -I /usr/include                                      */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/* $Log:	jday.c,v $
 * Revision 1.2  2001/06/19  13:23:52  13:23:52  oasisa (Oasis users)
 * Added header, logs, revision
 * 
*/

#include <stdio.h>
#include <math.h>
#include <time.h>


main(argc,argv)
int argc;
char *argv[];
{
 unsigned IsLeapYear=0;
 int year,month,day;
 int i,j,jday;
 char *wdays[]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
 int mo_days[]={0,31,28,31,30,31,30,31,31,30,31,30,31};
 enum Months{JAN=1,FEB,MAR,APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC};
 struct tm *today,when;
 time_t ltime,wtime;
 
 if (argc<2){
	 time(&ltime);
	today = localtime( &ltime );
	printf("\n%02d/%02d/%04d is day %d\n",today->tm_mon+1,today->tm_mday,today->tm_year+1900,today->tm_yday+1);
	printf("Usage: %s mm/dd/yyyy\n\n",argv[0]);

	return(0);	
 }
 
 for(i=1;i<argc;i++){
  if (sscanf(argv[i],"%d/%d/%d",&month,&day,&year)==3){
    if(year%4==0)
		IsLeapYear=1;
	if(year%100==0 && year%400!=0)
		IsLeapYear=0;

	if(day>mo_days[month])
		if(!(day==29 && month==FEB && IsLeapYear)){
			printf("\nInvalid date\n\n");
			return(0);
		}
    for(j=0,jday=0;j<month;jday+=mo_days[j++]);

      jday+=(day+((IsLeapYear && month>FEB)?1:0));

      when.tm_mon = month-1;
      when.tm_mday = day;
      when.tm_year = year-1900;
      wtime=mktime(&when);
      printf("%s %02d/%02d/%04d is day %d\n",wdays[when.tm_wday],when.tm_mon+1,when.tm_mday,when.tm_year+1900,when.tm_yday+1);
      printf("\n%02d/%02d/%04d is day %d\n",month,day,year,jday);

      printf("Usage: %s mm/dd/yyyy\n\n",argv[0]);
  }
 }
return(0);
}
