/************************************************************************/
/* Copyright 1988 MBARI							*/
/************************************************************************/

/************************************************************************/
/* Summary  : General Type Definitions					*/
/* Filename : TYPES.H							*/
/* Author   : Daniel Davis, Gregg Morris				*/
/* Project  : 								*/
/* Version  : Version 1.0						*/
/* Created  : 03/05/88							*/
/* Modified : 03/27/90							*/
/* Archived :								*/
/************************************************************************/
/* Modification History:						*/
/* 26feb90 rah - added modification history, deleted MSDOS stuff	*/
/* 07mar90 rah - added BitVec						*/
/************************************************************************/

#ifndef MBARI_TYPES

#define MBARI_TYPES	1

#define Extern		extern
#define MLocal		static
#define Global		/**/

#ifndef NULL
#define NULL	((Char *)0)
#endif

#ifndef Reg
#define Reg		register
#endif


/*
*	Basic types:
*/
#define Void		void	/* No value returned type		*/

typedef unsigned char	Char;	/* character, whatever that is - here	*/
				/* it is 8-bit ASCII			*/

typedef unsigned char	Byte;	/* Byte - i.e. 8 bit vector, cannot add */
				/* or subtract, multiply or divide, but */
				/* can perform bit vector operations,	*/
				/* such as OR, XOR, AND, NOT, EQUAL	*/

typedef unsigned short	Word;	/* word - i.e. 16 bit vector		*/

typedef unsigned long	DWord;	/* double word - i.e. 32 bit vector	*/

typedef short int	Int16;	/* integer, 15 bits of precision with	*/
				/* a sign, for arithmetic operations	*/

typedef long int	Int32;	/* integer, 31 bits of precision with	*/
				/* a sign, for arithmetic operations	*/

typedef int		Int;	/* integer for scratch use, don't care	*/
				/* about size				*/

typedef Int16		MBool;	/* Bool, i.e. TRUE or FALSE		*/
#ifndef Boolean
typedef MBool		Boolean;/* Note - This conflicts with X11.  It	*/
#endif				/*     will be deleted in the future	*/

typedef int		Ternean;/* Ternean, i.e. LEFT, RIGHT, STOP, etc.*/

typedef unsigned short	Nat16;	/* natural number, 16 bits of precision */
				/* for indexing and positive offsets	*/

typedef unsigned long	Nat32;	/* natural number, 32 bits of precision */
				/* for indexing and positive offsets	*/

typedef float		Flt32;	/* floating point number, 32 total bits	*/

typedef double		Flt64;	/* floating point number, 64 total bits	*/

typedef unsigned int	BitVec;	/* For bit vector operations		*/


/*
*	Compound types:
*/

typedef Int32		RetCode;/* index for return message		*/

typedef Int32		Addr;	/* Addr address				*/

#endif
