# Calibration file for PRR-600 Spectroradiometers on OASIS Mooring M2
# Model PRR-600
# File created 5nov93, modified 15jul96
#
# Format of this file was chosen to be consistent with Biospherical cal file
# 
# First line has one entry for each address tag, specifying number of
#  channels for that address tag
#
# There follows one line of calibration data for each channel as follows:
#  bank chan type name  a  b  c  cmin cmax units
#
# bank:  Bank number, i.e., the address tag for a given bank of channels
# chan:  Channel number
# type:  Type of channel, as follows: 0 = unused, 1 = down irrad, 2 = analog,
#        3 = up radiance, 4 = up irrad, 5 = quadratic, 6 = Old Satlantic cals
#	 7 = New Satlantic cals (b is multiplier) or MCP
#        Once a count is converted to a voltage, via fixed algorithm,
#	 the voltage is converted to given units as follows:
#	 Type 0:       not converted or reported
#	 Types 1 - 4:  value = (volts - c) / b  (a is unused)
#	 Type 5:       value = a + (b * volts) + (c * volts^2)
#	 Type 6:       value = a * (volts - c) / b
#	 Type 7:       value = a * b * (volts - c)
# name:  Name of channel
# a:     Calibration "a" value, unused for types 1-4
# b:     Calibration "b" value
# c:     Calibration "c" value, unused for type 6
# cmin:  unused
# cmax:  unused
# units: Units that value decodes into

12 16 14 8

# Surface instrument, Serial 9664, Calibration date 4jun96
0  1 1 Ed412  0.0 -0.034257 -0.000370 0 10 uwatts/cm2/nm
0  2 1 Ed443  0.0 -0.033874 -0.000977 0 10 uwatts/cm2/nm
0  3 1 Ed490  0.0 -0.034658 -0.000318 0 10 uwatts/cm2/nm
0  4 1 Ed510  0.0 -0.034451 -0.000225 0 10 uwatts/cm2/nm
0  5 1 Ed555  0.0 -0.034199 -0.000238 0 10 uwatts/cm2/nm
0  6 1 Ed656  0.0 -0.032990  0.000045 0 10 uwatts/cm2/nm
0  7 2 PAR   0.0 -14.615301 -0.000178 0 10 uwatts/cm2/nm
0  8 2 Gnd    0.0  1.0      -0.000249 0 10 volts
0  9 2 Diode  0.0  0.1       0.0      0 10 degC
0 10 2 DGnd   0.0  1.0       0.0      0 10 volts
0 11 2 Pitch  0.0  0.0410    2.6786   0 10 degrees
0 12 2 Roll   0.0  0.0416    2.6549   0 10 degrees

# Satlantic surface instrument, Serial 118, Calibration date 18jun96
1  1 7 Lu412  1.748 -0.6632  .000216 0 5 uwatts/cm2/nm/str
1  2 7 Lu443  1.742 -0.6933 -.000410 0 5 uwatts/cm2/nm/str
1  3 7 Lu490  1.736 -0.6733  .000072 0 5 uwatts/cm2/nm/str
1  4 7 Lu510  1.733 -0.5941  .000265 0 5 uwatts/cm2/nm/str
1  5 7 Lu555  1.729 -0.6042  .000225 0 5 uwatts/cm2/nm/str
1  6 7 Lu670  1.721 -0.2574  .000692 0 5 uwatts/cm2/nm/str
1  7 7 Lu683  1.720 -0.2442  .000158 0 5 uwatts/cm2/nm/str
1  8 2 Gnd    0.0    1.0    0.0      0 5 volts

# Satlantic surface instrument, Serial 119, Calibration date 18jun96
1  9 7 Lu412  1.748 -0.6409  .001124  0 5 uwatts/cm2/nm/str
1 10 7 Lu443  1.742 -0.7145  .000048 0 5 uwatts/cm2/nm/str
1 11 7 Lu490  1.736 -0.6640 -.000431 0 5 uwatts/cm2/nm/str
1 12 7 Lu510  1.733 -0.6168  .000130 0 5 uwatts/cm2/nm/str
1 13 7 Lu555  1.729 -0.5873 -.000397 0 5 uwatts/cm2/nm/str
1 14 7 Lu670  1.721 -0.2684  .000501 0 5 uwatts/cm2/nm/str
1 15 7 Lu683  1.720 -0.2452  .000150 0 5 uwatts/cm2/nm/str
1 16 2 Gnd    0.0    1.0    0.0      0 5 volts

# 20 meter instrument, Serial 9661, Calibration date 23may96
2  1 1 Ed412  0.0 -0.022374 -0.000363 0 10 uwatts/cm2/nm
2  2 1 Ed443  0.0 -0.022707 -0.000317 0 10 uwatts/cm2/nm
2  3 1 Ed490  0.0 -0.023111 -0.000512 0 10 uwatts/cm2/nm
2  4 1 Ed510  0.0 -0.023357 -0.000585 0 10 uwatts/cm2/nm
2  5 1 Ed555  0.0 -0.024034 -0.000533 0 10 uwatts/cm2/nm
2  6 1 Ed656  0.0 -0.023378 -0.000289 0 10 uwatts/cm2/nm
2  7 1 PAR    0.0 -10.656494 -0.000464 0 10 uE/cm2/s
2  8 2 Gnd    0.0  1.0      -0.000421 0 10 volts
2  9 2 Temp   0.0  0.0744    0.0015   0 10 degC
2 10 5 Depth  0.7241 74.3939 16.1892  0 10 dbars

# 10m MCP-200, Serial 7185, Calibration date 10apr96
2 11 7 MCP    1.0 -90.802    0.0005   0 10 uwatts/cm2/nm
#2 11 7 MCP    1.0  1.0       0.0       0 10 volts

# 30m MCP-200, Serial 7186, Calibration date 10apr96
2 12 7 MCP     1.0 -82.349   0.0005   0 10 uwatts/cm2/nm
#2 12 7 MCP     1.0  1.0      0.0      0 10 volts
2 13 2 Fluor   0.0  1.0      0.0      0 10 volts
2 14 2 Gnd     0.0  1.0      0.001497 0 10 volts

# 20 meter instrument, Serial 9661
3  1 3 NatF   0.0 -0.016897 -0.000487 0 10 nE/m2/sr/sec
3  2 3 Lu412  0.0 -0.733739 -0.001209 0 10 uwatts/cm2/nm/str
3  3 3 Lu443  0.0 -0.847566 -0.000896 0 10 uwatts/cm2/nm/str
3  4 3 Lu490  0.0 -1.028737 -0.000698 0 10 uwatts/cm2/nm/str
3  5 3 Lu510  0.0 -1.073771 -0.000737 0 10 uwatts/cm2/nm/str
3  6 3 Lu555  0.0 -1.621313 -0.000883 0 10 uwatts/cm2/nm/str
3  7 3 Lu656  0.0 -0.969559 -0.000483 0 10 uwatts/cm2/nm/str
3  8 2 Gnd    0.0  1.0      -0.000508 0 10 volts
