/****************************************************************************/
/* Copyright 1991 MBARI                                                     */
/****************************************************************************/
/* $Header: file.c,v 2.6 96/05/30 15:07:55 bobh Exp $			    */
/* Summary  : File Handling Routines for `extract`			    */
/* Filename : file.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 2.6 $							    */
/* Created  : 02/05/91							    */
/****************************************************************************/
/* Modification History:						    */
/* 14nov96 rah - created						    */
/* $Log$
*/
/****************************************************************************/

#include <mbariTypes.h>			/* MBARI type definitions	    */
#include <mbariConst.h>			/* MBARI constants		    */
#include <decode.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>


/********************************/
/*	Global Data		*/
/********************************/

Global Int	optind = 1;		/* Option index for getopt()	    */
Global char	*optarg;		/* Option argument for getopt()     */


/************************************************************************/
/* Function    : getopt							*/
/* Purpose     : Get command line option				*/
/* Inputs      : argc, argv, option format				*/
/* Outputs     : Option letter						*/
/************************************************************************/
	Int
getopt( Int argc, char **argv, char *fmt )
{
    Reg char	*p, *fmtptr;

    if ( optind >= argc )
	return( EOF );
    
    p = argv[optind];

    deblank(p);

    if ( *p++ != '-' )
	return( EOF );

    fmtptr = strchr(fmt, *p);

    if ( (*p == ':') || (fmtptr == NULL) )
	return( EOF );

    optind++;
    optarg = p;
    optarg++;
    fmtptr++;
    
    if ( *fmtptr == ':' )
    {
	if ( *optarg == '\0' )
	    optarg = argv[optind++];

	deblank(optarg);
    }    
    return( *p );
    
} /* getopt() */
