/****************************************************************************/
/* Copyright 1996 MBARI                                                     */
/****************************************************************************/
/* $Header: shutter.c,v 4.4 2001/06/19 12:15:36 oasisa Exp $                    */
/* Summary  : Driver Routines for Shutters for PRR Spectro                  */
/* Filename : shutter.c                                                     */
/* Author   : Robert Herlien (rah)                                          */
/* Project  : OASIS Mooring                                                 */
/* $Revision: 4.4 $                                                         */
/* Created  : 06/13/96                                                      */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:                                                    */
/* 13jun96 rah - created                                                    */
/* $Log:	shutter.c,v $
 * Revision 4.4  2001/06/19  12:15:36  12:15:36  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:56  11:44:56  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.8  97/09/12  10:51:00  10:51:00  bobh (Bob Herlien)
 * Redeploy M1
 * 
 * Revision 3.7  97/07/23  11:18:20  11:18:20  bobh (Bob Herlien)
 * July '97 M1 deployment, new shutter code
 * 
 * Revision 3.6  96/10/30  14:00:22  14:00:22  bobh (Bob Herlien)
 * Release for EqPac, M2 Test Replacement
 * 
 * Revision 3.5  96/07/17  13:01:40  13:01:40  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
 * Revision 3.4  96/06/18  15:24:34  15:24:34  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
*/
/****************************************************************************/

#include <types.h>                      /* MBARI type definitions           */
#include <const.h>                      /* MBARI constants                  */
#include <oasis.h>                      /* OASIS controller definitions     */
#include <io.h>                         /* OASIS I/O definitions            */
#include <log.h>                        /* Log record definitions           */
#include <custom.h>                     /* SHUTTER definition               */
#include <80C196.h>                     /* 80196 Register mapping           */
#include <string.h>                     /* string functions                 */
#include <task.h>                       /* OASIS Multitasking definitions   */


/************************************************************************/
/* Function    : shutter_drv                                            */
/* Purpose     : Driver to open or shut the shutter(s) on the PRR Spectro*/
/* Inputs      : Driver ptr, Boolean for open or close, sem ID for open */
/* Outputs     : None                                                   */
/************************************************************************/
	Void
shutter_drv( Driver *dp, MBool open, SemID sem )
{
    if ( open )
    {
/* Do stuff to open shutter, then ... */
	sem_give( sem );
    }
    
} /* shutter_drv() */
