/************************************************************************/
/* Copyright 1997 MBARI                                                 */
/************************************************************************/
/* $Header: shut22.h,v 4.4 2001/06/19 12:15:29 oasisa Exp $                   */
/* Summary  : Shutter defs and types for the OASIS mooring controller   */
/* Filename : shut22.h                                                  */
/* Author   : Dave Wright dkw                                           */
/* Project  : OASIS Mooring                                             */
/* $Revision: 4.4 $                                                     */
/* Created  : 9:58 AM 7/15/97                                           */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:                                                */
/* created 9:58 AM 7/15/97                                              */
/************************************************************************/


/************************************************************************/
/* drv_parm    : PARM0 is shutter number                                */
/* usage       : PARM1 is closed position calibration                   */ 
/*             : PARM2 is number of attempts to complete operation      */
/*             : TIMEOUT is seconds allowed for each attempt            */
/************************************************************************/

#define SHUTTER_OPEN_SECTOR     360     /* width of open sector */
#define SHUTTER_CLOSED_SECTOR   6       /* width of closed sector */
#define SHUTTER_POLL            2       /* ticks per sample of shutter position */
#define MAX_SHUT_FAILURES       11       /* after which we cease trying */

#define CCW                     FALSE   /* Counter clockwise shutter rotation */
#define CW                      TRUE    /* Clockwise shutter rotation */

typedef enum 
{
    OPEN, CLOSED, INTER
} State ;                       /* possible states of shutter */

typedef enum
{
    RUN, STOP, OVERLOAD
} Motor ;                       /* possible states of motor drive hardware */

typedef struct 
{
    MBool       Open;           /* operation type, TRUE = open */
    Nat16       ShutterNumber;  /* which one  */
    Nat16       ClosePosition;  /* the closed or reference position for this shutter */
    Nat16       TryCount;       /* attempt --counter */
    Nat16       MaxTicks;       /* timeout value for each attempt */
    Nat16       ErrCode;        /* success or failure of move */
} Shutter_data ;

/****************************************/
/* Function Declarations                */
/****************************************/

Void    startMotor( Shutter_data *sd );
Void    stopMotor( Shutter_data *sd );
MBool   readMotor( Shutter_data *sd );
Void    setDirMotor( MBool clockwise,Shutter_data *sd );
MBool   readDirMotor( Shutter_data *sd );
Nat16   readShutter(Shutter_data *sd);
State   sector(Shutter_data *sd);
Void    initMotor( Shutter_data *sd );


/* END shut22.h */
