/****************************************************************************/
/* Copyright 1995 MBARI                                                     */
/****************************************************************************/
/* $Header: serInst.c,v 4.4 2001/06/19 12:15:23 oasisa Exp $		    */
/* Summary  : Driver Routines for Oxygen Sensor on OASIS mooring	    */
/* Filename : serInst.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 04/05/95							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 05apr95 rah - created						    */
/* $Log:	serInst.c,v $
 * Revision 4.4  2001/06/19  12:15:23  12:15:23  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:43  11:44:43  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.4  96/06/18  15:24:30  15:24:30  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
 * Revision 3.2  95/04/11  14:03:32  14:03:32  hebo (Bob Herlien)
 * Drifter Deployment on IronEx
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <log.h>			/* Log record definitions	    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <task.h>			/* OASIS Multitasking definitions   */

#define BUFFER_SIZE	512		/* Size of serial buffer	    */


/********************************/
/*	External Functions	*/
/********************************/

Extern Void	drvLog( Driver *dp, Byte *samplep, Int16 len );
Extern char	*drvSerPortAndMalloc( Driver *dp, Nat16 size );
Extern Void	drvSerReleaseAndFree( Driver *dp, char *buffer );
Extern Int16	xgetn_tmout( char *s, Int16 len, Nat16 tmout );
Extern char	*tmpMalloc( Nat16 size );
Extern Void	tmpFree( char *ptr );
Extern Void	delay_secs( Nat16 secs );


/************************************************************************/
/* Function    : serialInstr_drv					*/
/* Purpose     : Oxygen Sensor driver					*/
/* Inputs      : Driver Pointer						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
serialInstr_drv( Driver *dp )
{
    Reg Int16	len;
    char	*buf;			/* Buffer for serial data	*/

    if ( (buf = drvSerPortAndMalloc(dp, BUFFER_SIZE)) == NULL )
	return;

    delay_secs( dp->drv_parms[PARM0] );
    
    if ( (len = xgetn_tmout(buf, BUFFER_SIZE, dp->drv_parms[TIMEOUT])) > 0 )
	drvLog( dp, (Byte *)buf, len );

    drvSerReleaseAndFree( dp, buf );	 /* Release serial port & buffer*/

} /* serialInstr_drv() */
