/****************************************************************************/
/* Copyright 1995 MBARI                                                     */
/****************************************************************************/
/* $Header: sbe47_ct.c,v 1.1 2001/10/17 10:32:30 oasisa Exp $		    */
/* Summary  : Driver Routines for Seabird SBE47 CT on OASIS mooring	    */
/* Filename : sbe47_ct.c						    */
/* Author   : Kent Headley (klh)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 1.1 $							    */
/* Created  : 10/10/2001 from ctd.c					    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 10oct01 klh - created from ctd.c					    */
/* $Log:	sbe47_ct.c,v $
 * Revision 1.1  2001/10/17  10:32:30  10:32:30  oasisa (Oasis users)
 * Initial revision
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <log.h>			/* Log record definitions	    */
#include <custom.h>			/* CTD_TS definition		    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <task.h>			/* OASIS Multitasking definitions   */
#include <stdio.h>			/* Standard I/O functions	    */

#define CTD_BUFSIZE	32		/* Leave a little extra room for CTD*/


/********************************/
/*	External Functions	*/
/********************************/

Extern Void	drvLog( Driver *dp, Byte *samplep, Int16 len );
Extern Void	drvLogError( Driver *dp, Errno err );
Extern Void	drv_ser_port( Driver *dp );
Extern Void	drv_ser_release( Driver *dp );
Extern Void	drv_pwroff( Driver *dp );
Extern Void	xputc( Int16 c );
Extern Int16	xgets_tmout( char *s, Int16 len, Nat16 tmout );
#ifdef PUMP_SYNC_CTD
Extern Void	drvSync( char *name );
#endif


/************************************************************************/
/* Function    : sbe47_ct_drv						*/
/* Purpose     : CTD driver						*/
/* Inputs      : Driver Pointer						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
sbe47_ct_drv( Driver *dp )
{
    Int16	i, size, len;
    char	ctd_buf[CTD_BUFSIZE];	/* Buffer for CTD data		*/
    Reg Int16	nchars;			/* char count			*/
    Nat16	tmout;			/* Timeout			*/
    
    drv_ser_port( dp );			/* Get serial port		*/

#ifdef PUMP_SYNC_CTD
    drvSync( PUMP_SYNC_CTD );		/* Wait for water pump		*/
#endif

    size = dp->drv_parms[PARM0];	/* Find number bytes to look for*/
    if ( size > CTD_BUFSIZE )		/* If more than buffer, truncate*/
	size = CTD_BUFSIZE;

    tmout = dp->drv_parms[TIMEOUT];	/* Get timeout			*/

    for ( i = dp->drv_parms[PARM1]; (i>0 && len<size) ; i-- ){
      len=0;
      xputc('\r');			/* Get CTD's attention		*/
      len=xgets_tmout(ctd_buf, CTD_BUFSIZE, tmout);
    }

    drv_ser_release( dp );		/* Release serial port		*/

    if(len>0)
      drvLog( dp, (Byte *)ctd_buf, len );	/* Log CTD data			*/
    else
    if(len<0)
      drvLogError(dp,BAD_DATA);
    else
      drvLogError(dp,SYNC_ERR);

    drv_pwroff( dp );			/* Turn off power		*/

} /* sbe47_ct_drv() */
