/****************************************************************************/
/* Copyright 1995 MBARI                                                     */
/****************************************************************************/
/* $Header: sbe43_o2.c,v 1.1 2001/10/17 10:31:46 oasisa Exp $			    */
/* Summary  : Driver Routines for SBE43 analog Oxygen Sensor                */
/* Filename : sbe43_o2.c						    */
/* Author   : Kent Headley (klh)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 1.1 $								    */
/* Created  : 09/27/01							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* $Log:	sbe43_o2.c,v $
 * Revision 1.1  2001/10/17  10:31:46  10:31:46  oasisa (Oasis users)
 * Initial revision
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <log.h>			/* Log record definitions	    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <task.h>			/* OASIS Multitasking definitions   */
#include <custom.h>                     /* for PUMP_SYNC                    */

/********************************/
/*	External Functions	*/
/********************************/

Extern Void     analog_drv( Driver *dp );
Extern Void	drvSync( char *name );


/************************************************************************/
/* Function    : sbe43_o2_drv						*/
/* Purpose     : Oxygen Sensor driver					*/
/* Inputs      : Driver Pointer						*/
/* Outputs     : None							*/
/* Notes       : Needed to sync pump to analog instrument; did not want */
/*               to add sync code to analog_drv                         */
/************************************************************************/
	Void
sbe43_o2_drv( Driver *dp )
{

#ifdef PUMP_SYNC_O2
    drvSync( PUMP_SYNC_O2 );		/* Wait for water pump		*/
#endif
    analog_drv(dp);

} /* sbe43_o2_drv() */
