/****************************************************************************/
/* Copyright 1995 MBARI                                                     */
/****************************************************************************/
/* $Header: sat.h,v 4.4 2001/06/19 12:15:15 oasisa Exp $			    */
/* Summary  : Driver Routines for Satlantic S/N25 on OASIS mooring	    */
/* Filename : sat.c							    */
/* Author   : Danelle E. Cline						    */
/* Project  : OASIS M3 Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 02/15/95							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 26feb98  DCline- created	     					    */
/* $Log:	sat.h,v $
 * Revision 4.4  2001/06/19  12:15:15  12:15:15  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:37  11:44:37  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.0  98/03/09  11:44:37  11:44:37  bobh (Bob Herlien)
 * M3 Deployment of March '98, new Sat-Pac driver
 * 
 * 
*/
/****************************************************************************/

#ifndef _SAT_H
#define _SAT_H


#include <types.h>
#include <const.h>
#include <oasis.h>	

#define BUFF_SIZE 100		/*Based on 11chan, 16-bit data + time/date*/
#define NUM_CHAN_LOG 11		/*Number of channels echoed from SAT-DAT. 
							  Set to 11 16-bit(12-bit res) channels 0 - 10(A)   */

Void SatlanticDrv(Driver *dp);
Nat16 GetSamples(char *buf, char *timedate, Nat16 timeout);
Nat16 ParseSamples(char *buff, char *datetime);


#endif 
