/****************************************************************************/
/* Copyright 1996 MBARI                                                     */
/****************************************************************************/
/* $Header: pump.c,v 4.4 2001/06/19 12:15:00 oasisa Exp $			    */
/* Summary  : Driver Routines for Water Pump for OASIS Mooring		    */
/* Filename : pump.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 06/13/96							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 13jun96 rah - created						    */
/* $Log:	pump.c,v $
 * Revision 4.4  2001/06/19  12:15:00  12:15:00  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:33  11:44:33  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.3  99/06/16  10:21:37  10:21:37  bobh (Bob Herlien)
 * Mar/May '99 Deployments of M3/M2
 * 
 * Revision 3.5  96/07/17  13:01:39  13:01:39  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
 * Revision 3.4  96/06/18  15:24:34  15:24:34  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
*/
/****************************************************************************/

#include <types.h>			/* MBARI type definitions	    */
#include <const.h>			/* MBARI constants		    */
#include <oasis.h>			/* OASIS controller definitions	    */
#include <io.h>				/* OASIS I/O definitions	    */
#include <log.h>			/* Log record definitions	    */
#include <80C196.h>			/* 80196 Register mapping           */
#include <string.h>			/* string functions		    */
#include <task.h>			/* OASIS Multitasking definitions   */


/********************************/
/*	External Functions	*/
/********************************/

Extern Void	drv_pwron( Driver *dp );
Extern Void	drv_pwroff( Driver *dp );
Extern Void	drvLog( Driver *dp, Byte *samplep, Int16 len );


/************************************************************************/
/* Function    : pump_drv						*/
/* Purpose     : Water Pump driver					*/
/* Inputs      : Driver Pointer						*/
/* Outputs     : None							*/
/************************************************************************/
	Void
pump_drv( Driver *dp )
{
    Byte	logByte;

    logByte = 1;
    drvLog( dp, &logByte, 1 );

    drv_pwron( dp );			  /* Turn on pump		*/

    delay_secs( dp->drv_parms[TIMEOUT] ); /* Wait for flush time	*/
    dp->drv_flags &= ~DO_SYNC;		  /* Notify waiting routines	*/

    delay_secs( dp->drv_parms[PARM0] );	  /* Let run for remaining time	*/

    drv_pwroff( dp );			  /* Turn off pump		*/

    logByte = 0;
    drvLog( dp, &logByte, 1 );

} /* pump_drv() */
