;****************************************************************************
;* Copyright 1991 MBARI                                                     *
;****************************************************************************
;* $Header: oregs.s,v 4.4 2001/06/19 12:14:56 oasisa Exp $			    *
;* Summary  : Definitions for OASIS hardware registers			    *
;* Filename : oregs.s							    *
;* Author   : Robert Herlien						    *
;* Project  : OASIS Mooring Controller                                      *
;* $Revision: 4.4 $							    *
;* Created  : 12/09/94							    *
;*									    *
;* MBARI provides this documentation and code "as is", with no warranty,    *
;* express or implied, of its quality or consistency. It is provided without*
;* support and without obligation on the part of the Monterey Bay Aquarium  *
;* Research Institute to assist in its use, correction, modification, or    *
;* enhancement. This information should not be published or distributed to  *
;* third parties without specific written permission from MBARI.            *
;*									    *
;****************************************************************************
;
OREGS		MODULE
;
;****************************************************************
;
;		DEFINITIONS FOR EXTERNAL I/O
;
;****************************************************************
;
IO 		EQU	200H		;MUST agree with IO def'ns in oasis.h
UARTS		EQU	400H
UARTA		EQU	(UARTS + 10H)
UARTB		EQU	(UARTS + 20H)
PIAA		EQU	(UARTS + 30H)
PIAB		EQU	(UARTS + 40H)
ROCKY		EQU	600H		;Rocky board address
ROCKYIO		EQU	(ROCKY + 10H)


PUBLIC	relay0_enbl, bank_port, oasis_ctrl
PUBLIC	relay1_enbl, pwr_enbl, wakeport
PUBLIC	uarta_data, uarta_ucr, uarta_usr, uarta_mcr, uarta_brsr, uarta_msr
PUBLIC	uartb_data, uartb_ucr, uartb_usr, uartb_mcr, uartb_brsr, uartb_msr
PUBLIC	piaa_p1da, piaa_p2da, piaa_pda, piaa_pdb, piaa_pdc
PUBLIC	piaa_ddra, piaa_ddrb, piaa_ddrc, piaa_cra, piaa_crb
PUBLIC	piaa_fsr, piaa_p1db, piaa_p2db, piaa_hsr, piaa_hwr
PUBLIC	piab_p1da, piab_p2da, piab_pda, piab_pdb, piab_pdc
PUBLIC	piab_ddra, piab_ddrb, piab_ddrc, piab_cra, piab_crb
PUBLIC	piab_fsr, piab_p1db, piab_p2db, piab_hsr, piab_hwr
PUBLIC  ledon,ledoff
	
relay0_enbl	equ	(IO):WORD	;  W Relay 0 enable ports
bank_port	equ	(IO+2):BYTE	;  W Bank memory select port
oasis_ctrl	equ	(IO+3):BYTE	;  W Control bit port

relay1_enbl	equ	(ROCKYIO+4):WORD ;  W Relay 1 enable ports
pwr_enbl	equ	(ROCKYIO):WORD	 ;  W 16 bits of power FETs
wakeport	equ	(ROCKYIO+2):BYTE ;  W Wakeup bits
ledon		equ     (ROCKYIO+60H):BYTE  ;  B Blinky Light On
ledoff		equ     (ROCKYIO+50H):BYTE  ;  B Blinky Light Off

uarta_data	equ	(UARTA):BYTE	;R/W UARTA data port 
uarta_ucr	equ	(UARTA+1):BYTE	;  W UARTA uart control reg
uarta_usr	equ	(UARTA+1):BYTE	;R   UARTA uart status reg
uarta_mcr	equ	(UARTA+2):BYTE	;R/W UARTA modem control reg
uarta_brsr	equ	(UARTA+3):BYTE	;  W UARTA baud rate select reg
uarta_msr	equ	(UARTA+3):BYTE	;R   UARTA modem status reg

uartb_data	equ	(UARTB):BYTE	;R/W UARTB data port 
uartb_ucr	equ	(UARTB+1):BYTE	;  W UARTB uart control reg
uartb_usr	equ	(UARTB+1):BYTE	;R   UARTB uart status reg
uartb_mcr	equ	(UARTB+2):BYTE	;R/W UARTB modem control reg
uartb_brsr	equ	(UARTB+3):BYTE	;  W UARTB baud rate select reg
uartb_msr	equ	(UARTB+3):BYTE	;R   UARTB modem status reg

piaa_p1da	equ	(PIAA):BYTE	;R/W PIAA port A data, Clear CA1
piaa_p2da	equ	(PIAA+1):BYTE	;R/W PIAA port A data, Clear CA2
piaa_pda	equ	(PIAA+2):BYTE	;R/W PIAA port A data
piaa_pdb	equ	(PIAA+3):BYTE	;R/W PIAA port B data
piaa_pdc	equ	(PIAA+4):BYTE	;R/W PIAA port C data
piaa_ddra	equ	(PIAA+6):BYTE	;R/W PIAA data direction for port A
piaa_ddrb	equ	(PIAA+7):BYTE	;R/W PIAA data direction for port B
piaa_ddrc	equ	(PIAA+8):BYTE	;R/W PIAA data direction for port C
piaa_cra	equ	(PIAA+9):BYTE	;R/W PIAA control register for port A
piaa_crb	equ	(PIAA+10):BYTE	;R/W PIAA control register for port B
piaa_fsr	equ	(PIAA+11):BYTE	;R/W PIAA function select reg port C
piaa_p1db	equ	(PIAA+12):BYTE	;R/W PIAA port B data, Clear CB1
piaa_p2db	equ	(PIAA+13):BYTE	;R/W PIAA port B data, Clear CB2
piaa_hsr	equ	(PIAA+14):BYTE	;R/W PIAA handshake/interrupt status
piaa_hwr	equ	(PIAA+15):BYTE	;R/W PIAA handshake warning register

piab_p1da	equ	(PIAB):BYTE	;R/W PIAB port A data, Clear CA1
piab_p2da	equ	(PIAB+1):BYTE	;R/W PIAB port A data, Clear CA2
piab_pda	equ	(PIAB+2):BYTE	;R/W PIAB port A data
piab_pdb	equ	(PIAB+3):BYTE	;R/W PIAB port B data
piab_pdc	equ	(PIAB+4):BYTE	;R/W PIAB port C data
piab_ddra	equ	(PIAB+6):BYTE	;R/W PIAB data direction for port A
piab_ddrb	equ	(PIAB+7):BYTE	;R/W PIAB data direction for port B
piab_ddrc	equ	(PIAB+8):BYTE	;R/W PIAB data direction for port C
piab_cra	equ	(PIAB+9):BYTE	;R/W PIAB control register for port A
piab_crb	equ	(PIAB+10):BYTE	;R/W PIAB control register for port B
piab_fsr	equ	(PIAB+11):BYTE	;R/W PIAB function select reg port C
piab_p1db	equ	(PIAB+12):BYTE	;R/W PIAB port B data, Clear CB1
piab_p2db	equ	(PIAB+13):BYTE	;R/W PIAB port B data, Clear CB2
piab_hsr	equ	(PIAB+14):BYTE	;R/W PIAB handshake/interrupt status
piab_hwr	equ	(PIAB+15):BYTE	;R/W PIAB handshake warning register


		END
