/************************************************************************/
/* Copyright 1991 MBARI							*/
/************************************************************************/
/* $Header: oasis.h,v 4.4 2001/06/19 12:14:50 oasisa Exp $			*/
/* Summary  : Definitions for the OASIS mooring controller using 87C196	*/
/* Filename : oasis.h							*/
/* Author   : Robert Herlien (rah)					*/
/* Project  : OASIS Mooring						*/
/* $Revision: 4.4 $							*/
/* Created  : 02/06/91							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 06feb91 rah - created						*/
/* $Log:	oasis.h,v $
 * Revision 4.4  2001/06/19  12:14:50  12:14:50  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:26  11:44:26  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.2  98/09/09  10:47:54  10:47:54  bobh (Bob Herlien)
 * Sept/Oct '98 deployments of M1, Eqpac 1 & 2
 * 
 * Revision 4.1  98/05/12  09:34:58  09:34:58  bobh (Bob Herlien)
 * June '98 turnaround for EqPac
 * 
 * Revision 3.9  97/10/28  13:59:23  13:59:23  bobh (Bob Herlien)
 * EqPac Deployment of Nov 1997
 * 
 * Revision 3.8  97/09/12  10:50:34  10:50:34  bobh (Bob Herlien)
 * Redeploy M1
 * 
 * Revision 3.7  97/07/23  11:17:51  11:17:51  bobh (Bob Herlien)
 * July '97 M1 deployment, new shutter code
 * 
 * Revision 3.5  96/07/17  13:01:12  13:01:12  bobh (Bob Herlien)
 * July '96 deployment of M2 with ARGOS code
 * 
 * Revision 3.4  96/06/18  15:24:01  15:24:01  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
 * Revision 3.3  95/04/13  13:46:40  13:46:40  hebo (Bob Herlien)
 * Drifter Deployment for Coop (flip) cruise
 * 
 * Revision 3.1  95/03/09  19:30:46  19:30:46  hebo (Bob Herlien)
 * March '95 Deployment of M1A
 * 
 * Revision 3.0  95/02/21  18:42:30  18:42:30  hebo (Bob Herlien)
 * February '95 Deployment
 * 
 * Revision 2.4  93/10/29  11:12:22  11:12:22  hebo (Bob Herlien)
 * November 1993 Deployment
 * 
 * Revision 2.3  93/10/12  08:29:29  08:29:29  hebo (Bob Herlien)
 * Oct '93 Deployment of M2
 * 
 * Revision 2.0  92/08/26  10:32:35  10:32:35  hebo (Bob Herlien)
 * August 1992 Deployment
 * 
 * Revision 1.3  92/03/03  16:38:37  16:38:37  hebo (Bob Herlien 408-647-3748)
 * New defaults, restart check, perm power stuff, analog command
 * 
*/
/************************************************************************/

#ifndef INCoasish
#define INCoasish	1

#pragma	model(kc)
#pragma regconserve

#define Number(arr)		((sizeof(arr) / sizeof(arr[0])))

#define Offset(ptr_type,field)	((Nat16)&(((ptr_type)0)->field))
#define OffsetOf(s_type,field)	Offset(s_type *,field)


/****************************************/
/* Memory layout for OASIS controller	*/
/****************************************/

#define TEMP_RAM	0xb000		/* Start of Temporary data RAM	    */
#define TEMP_RAM_SIZE	0x3000		/* Length of Temp data RAM	    */
#define PERM_RAM	0xe000		/* Start of Perm allocatable RAM    */
#define PERM_RAM_SIZE	0x1e00		/* Leave room for disk sector buffer*/


/****************************************/
/* Miscellaneous typedefs and defines	*/
/****************************************/

#define MAGIC		0xc35a		/* Arbitrary pattern signifys RAM OK*/

/* Error Codes */
typedef short int	Errno;		/* Error number return code	    */
#ifndef ERROR			/* ERROR and OK defined in <const.h>	    */
#define ERROR		(-1)	/* ERROR return code, same as <const.h>	    */
#define OK		0	/* OK return code, same as <const.h>	    */
#endif
#define TMOUT_ERR	(-2)		/* Serial timeout		    */
#define MALLOC_ERR	(-3)		/* No buffer space from malloc	    */
#define NO_DATA		(-4)		/* No data from device		    */
#define BAD_DATA	(-5)		/* Bad data from device		    */
#define CKSUM_ERR	(-6)		/* Checksum failure		    */
#define SYNC_ERR	(-7)		/* Failure to sync to device	    */
#define	NOT_AVAIL_ERR	(-8)		/* Device says not avail (eg GPS)   */
#define	USR_INTERRUPT	(-9)		/* User interrupted		    */

#define ABORT		(-2)		/* Rtn code to abort user interface */

#define NO_TIMEOUT	(-1)		/* Infinite timeout parameter	    */
#define NO_SERIAL	(-1)		/*  NULL serial port		    */
#define XON		0x11		/* ASCII xon character		    */
#define XOFF		0x13		/* ASCII xoff character		    */

#define LOG_PWRUP	1		/* 1 in logStatus logs pwr up events*/
#define LOG_PWRDOWN	2		/* 2 in logStatus logs pwr down events*/
#define USR_BUFSIZE	256		/* User interface buffer size	    */
#define MAXLOGSIZE	2048		/* Max size of log record	    */
#define MAXADCPSIZE	2046		/* Max size for adcp record	    */
					/* Caution - must be < MAXLOGSIZE   */

#define RELAYS_OFF	0xaaaa		/* Word to turn all serial relays off*/

#define deblank(s)	while(isspace(*s)) ((s)++)
#define _to_upper(_c)	(isalpha(_c) ? (_c) & 0x5f : (_c))

/* Flags for xgets_tmout_flg() */
#define INCLUDE_TERMCHAR 1		/* Include termination char in buffer*/

typedef union				/************************************/
{					/* WordByte - Word <-> 2Byte convert*/
    Byte	wb_byte[2];		/* 2 Bytes			    */
    Nat16	wb_word;		/* Word				    */
} WordByte;				/************************************/

typedef union				/************************************/
{					/* IntByte - Int <-> 2 Byte convert */
    Byte	ib_byte[2];		/* 2 Bytes			    */
    Int16	ib_int;			/* 16 bit Integer		    */
} IntByte;				/************************************/


/****************************************/
/*	Time Data Types			*/
/****************************************/

typedef Nat32	TimeOfDay;		/* Time of Day format		    */
					/* seconds since 00:00:00 of 1/1/70 */
typedef Nat16	Date;			/* Days since 1/1/70		    */

#define YEAR0		70		/* Start year for TimeOfDay	    */
#define SECS_PER_DAY	86400L		/* Seconds per day		    */
#define MAX_ALARM_TIME	(12*3600)	/* Must wake up at least twice/day  */

typedef struct				/************************************/
{					/* DateTime Struct		    */
    Byte	dt_hr;			/* Hour				    */
    Byte	dt_min;			/* Minute			    */
    Byte	dt_sec;			/* Second			    */
    Byte	dt_yr;			/* Year				    */
    Byte	dt_mo;			/* Month			    */
    Byte	dt_day;			/* Day				    */
} DateTime;				/************************************/


/****************************************/
/*	Error Types			*/
/****************************************/

/* The following error types are used general system error indicators.	    */
					/************************************/
#define RAM_ERR		0x01		/* RAM not initialized		    */
#define LOG_ERR		0x02		/* Bogus log memory		    */
#define CLOCK_ERR	0x04		/* Real-time clock failure	    */
#define INT_ERR		0x08		/* Received spurious interrupt	    */
#define RESTART_ERR	0x10		/* Restarted with bad keepalive     */
#define COMM_ERR	0x20		/* Restartd due to no comm for 24hrs*/
#define DISK_ERR	0x40		/* Disk I/O error		    */
#define ARGOS_ERR	0x80		/* Error uploading to ARGOS	    */
					/************************************/
#define ERR_LOG_BIT	0x8000		/* Error is logged with MSB set	    */
					/************************************/

/****************************************/
/*	Drivers				*/
/****************************************/

typedef Void	*Tid;			/* Task ID, used in task.h	    */
#define NULLTID	((Tid)0)

/* Driver Parameters		*/
#define INTERVAL	 0		/* Seconds between samples	    */
#define SER_PORT	 1		/* Serial port to use (ERROR if none)*/
#define SER_SETUP	 2		/* Baud rate, ctrl bits		    */
#define SER_RELAY0	 3		/* Serial relay select		    */
#define SER_RELAY1	 4		/* Serial relay select		    */
#define PWR_CTRL	 5		/* Power control bit to use	    */
#define SAMPLE_TYPE	 6		/* Sample type field		    */
#define TOD_MASK	 7		/* 12 bit mask for hours to be off  */
#define TIMEOUT		 8		/* Normal timeout in seconds	    */
#define PARM0		 9		/* Extra parameter		    */
#define PARM1		10		/* Extra parameter		    */
#define PARM2		11		/* Extra parameter		    */

#define DRV_PARMS	(PARM2 + 1)	/* Number driver parameters	    */

typedef struct				/************************************/
{					/* DrvDesc - Driver Descriptor	    */
    char	*dd_name;		/* Name of driver		    */
    Void	(*dd_task)();		/* Entry point for driver task	    */
    MBool	(*dd_serwake)();	/* Serial wakeup function	    */
    Nat16	dd_parms[DRV_PARMS];	/* Driver parameters (see defns)    */
} DrvDesc;				/************************************/

typedef struct drvr_hdr Driver;		/* Driver struct type		    */

struct drvr_hdr				/************************************/
{					/* drvr_hdr - Driver header struct  */
    Driver	*drv_next;		/* For linked lists		    */
    Driver	*drv_prev;		/* For linked lists		    */
    char	*drv_name;		/* Name of driver		    */
    Void	(*drv_task)();		/* Entry point for driver task	    */
    MBool	(*drv_serwake)();	/* Serial wakeup function	    */
    Nat16	drv_parms[DRV_PARMS];	/* Driver parameters (see defns)    */
    TimeOfDay	drv_wakeup;		/* Nominal time to next wakeup	    */
    Tid		drv_td;			/* Task descriptor for driver	    */
    Word	drv_flags;		/* See "Driver Flags" below	    */
    Int16	drv_cnt;		/* Miscellaneous counter	    */
    Nat16	drv_usrparm;		/* Parameter passed directly to drvr*/
};					/************************************/

#define DRV_NULL	((Driver *)0)	/* NULL driver pointer		    */

/* Driver Flags		*/
#define DO_SYNC		1		/* Sync to incoming data	    */
#define DO_INIT		2		/* Initialize driver		    */
#define DO_AUX		4		/* Do aux function (cal, tape, etc) */
#define DO_ARGOS	8		/* Do ARGOS sampling		    */
#define FLAG_PERM	0x8000		/* Don't erase flags at task_exit   */

#endif	/* INCoasish */
