;****************************************************************************
;* Copyright 1996 MBARI							    *
;****************************************************************************
;* $Header  : misc.s,v 3.2 95/04/11 14:03:38 hebo Exp $			    *
;* Summary  : Miscellaneous assembly language routines for OASIS	    *
;* Filename : misc.s							    *
;* Author   : Robert Herlien						    *
;* Project  : OASIS Mooring Controller                                      *
;* $Revision: 4.4 $							    *
;* Created  : 04/26/96                                                      *
;*									    *
;* MBARI provides this documentation and code "as is", with no warranty,    *
;* express or implied, of its quality or consistency. It is provided without*
;* support and without obligation on the part of the Monterey Bay Aquarium  *
;* Research Institute to assist in its use, correction, modification, or    *
;* enhancement. This information should not be published or distributed to  *
;* third parties without specific written permission from MBARI.            *
;*									    *
;****************************************************************************
;
MISC		MODULE
;
$INCLUDE(..\C196\INCLUDE\8096.INC)
$INCLUDE(OASIS.INC)
;

		CSEG

PUBLIC	bcopy			;Byte copy routine
PUBLIC	bcopyBackwards		;Byte copy routine, high to low memory
PUBLIC	bzero			;Zero bytes
PUBLIC	swap			;Routine to swap bytes in a word
PUBLIC	swaplong		;Routine to swap bytes in a long word
PUBLIC  decToAscii		;Decimal-to-ASCII conversion routine


;*****************************************************************************
; bcopy - Copy bytes 
;
; Void bcopy( const Byte *src, Byte *dst, Nat16 len )
;
;	    Takes approx 6 usec/byte
;
; Register usage:  tmp0 = scratch
;		   tmp2 = word count
; 		   tmp4 = src ptr
;		   tmp6 = dst ptr
;

bcopy:
	ld	tmp4, 2[SP]		;Get source address
	ld	tmp6, 4[SP]		;Get destination address
	ld	tmp2, 6[SP]		;Get length to copy
bc1:
	ldb	tmp0b, [tmp4]+		;Move byte
	stb	tmp0b, [tmp6]+
	djnzw	tmp2, bc1
	ret


;*****************************************************************************
; bcopyBackwards - Copy bytes from high address to low
;
; Void bcopyBackwards( const Byte *src, Byte *dst, Nat16 len )
;
;	    Takes approx 8 usec/byte
;
; Register usage:  tmp0 = scratch
;		   tmp2 = word count
; 		   tmp4 = src ptr
;		   tmp6 = dst ptr
;

bcopyBackwards:
	ld	tmp4, 2[SP]		;Get source address
	ld	tmp6, 4[SP]		;Get destination address
	ld	tmp2, 6[SP]		;Get length to copy
	add	tmp4, tmp2		;Point to end of source
	add	tmp6, tmp2		;Point to end of destination
bcbw1:
	dec	tmp4
	ldb	tmp0b, [tmp4]		;Move byte
	dec	tmp6
	stb	tmp0b, [tmp6]
	djnzw	tmp2, bcbw1
	ret


;*****************************************************************************
; bzero - Zero bytes 
;
; Void bzero( Byte *dst, Nat16 len )
;
;	    Takes approx 4 usec/byte
;
; Register usage:  tmp2 = dst ptr
;		   tmp4 = word count
;

bzero:
	ld	tmp2, 2[SP]		;Get destination address
	ld	tmp4, 4[SP]		;Get length to zero
bz1:
	stb	R0, [tmp2]+		;Zero byte
	djnzw	tmp4, bz1
	ret


;*****************************************************************************
; SWAP - Swap bytes in a word
;
; Nat16 swap( Nat16 w )
;
swap:
	ldb	tmp0b, 3[SP]		;Get low byte
	ldb	tmp1b, 2[SP]		;Get high byte
	ret


;*****************************************************************************
; SWAPLONG - Convert long from Motorola to Intel or vice versa
;
; Nat32 swaplong( Nat32 lwrd )
;
swaplong:
	ldb	tmp0b, 5[SP]
	ldb	tmp1b, 4[SP]
	ldb	tmp2b, 3[SP]
	ldb	tmp3b, 2[SP]
	ret


;************************************************************************
; decToAscii - Convert decimal number to three ASCII digits
;
; char *decToAscii( char *buff, Nat16 val );
;
decToAscii:
	ld	tmp0, 2[SP]		;Point to buffer
	ld	tmp2, #3		;Convert 4 digits
	add	tmp0, tmp2		;Point to LSB of conversion buffer
	ld	tmp4, 4[SP]		;Get data to convert
dTAloop:
	ld	tmp6, R0
	divu	tmp4, #10
	addb	tmp6b, #30h
	dec	tmp0
	stb	tmp6, [tmp0]
	djnz	tmp2b, dTAloop

	add	tmp0, #3
	stb	R0, [tmp0]		;insert string terminator
	ret


	END
