/****************************************************************************/
/* Copyright 1998 MBARI                                                     */
/****************************************************************************/
/* $Header: metsys.h,v 4.4 2001/06/19 12:14:40 oasisa Exp $			    */
/* Summary  : Driver Routines for MetSys data logger on OASIS mooring	    */
/* Filename : metsys.h							    */
/* Author   : Danelle E. Cline						    */
/* Project  : OASIS M2 Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 02/10/98							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 10feb98  DCline- created	     					    */
/* $Log:	metsys.h,v $
 * Revision 4.4  2001/06/19  12:14:40  12:14:40  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:44:13  11:44:13  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.2  98/09/09  10:47:59  10:47:59  bobh (Bob Herlien)
 * Sept/Oct '98 deployments of M1, Eqpac 1 & 2
 * 
 * 
 * 
*/
/****************************************************************************/
#ifndef _METSYS_H
#define _METSYS_H

#include <types.h>
#include <const.h>
#include <oasis.h>	

typedef struct
{
	char type[2];
	char data[6];		/* sign + 4 digit precision + '.'*/ 
	char delimiter[2];	/* 2 spaces */
} dataRecord;

#define REC_SIZE		sizeof(dataRecord) 

#define BACKUP_CMD		"B\r"
#define MOVEMPTR_CMD	"G\r"
#define DUMP_CMD		"D\r"
#define STATUS_CMD		"A\r"

/*Error codes for status */
#define MET_RESYNC	0
#define MET_SYNC	1
#define MET_WAKUPFAILED	2

/*Max records in a data array dump */
#define NUM_REC 11							

/*Buffer size, holds one-11 record dump + echoed dump command */
#define BUFF_SIZE 200 

/*Metsys logger defined max check sum */
#define MAXCHECKSUM 8191

/*Number of internal logger memory locations for 128K buffer*/
#define NUM_MEM_LOC	62280 

Void MetSysDrv(Driver *dp);
Void MetSleep();
MBool WakeUp(Driver *dp);
Nat16 GetRecords(Driver *dp, char *buf);
Nat16 ParseData(char * buff, Nat16 *curReadPtr);
MBool VerifyCheckSum(char *buffer, Nat16 len);
Nat16 GetUnreadRecords(char *buff, Nat16 *newmptr, Nat16 *oldmptr);
Void MoveMPTR(Nat16 newPtr);
Void BackupMPTR(Nat16 n);
Nat16 ReadData(Driver *dp, char *buff, Nat16 *mptr);

#endif 
