$NOLIST

;************************************************************************
;* Copyright 1994 MBARI							*
;************************************************************************
;* Summary  : Definitions for I/O in OASIS mooring controller		*
;* Filename : io.inc							*
;* Author   : Robert Herlien (rah)					*
;* Project  : OASIS Mooring						*
;* Version  : 1.0							*
;* Created  : 12/12/94							*
;*									    *
;* MBARI provides this documentation and code "as is", with no warranty,    *
;* express or implied, of its quality or consistency. It is provided without*
;* support and without obligation on the part of the Monterey Bay Aquarium  *
;* Research Institute to assist in its use, correction, modification, or    *
;* enhancement. This information should not be published or distributed to  *
;* third parties without specific written permission from MBARI.            *
;*									    *
;************************************************************************
;* Modification History:						*
;* 12dec94 rah - created						*
;************************************************************************

;****************************************/
;* Serial Stuff
;****************************************/

NSER_PORTS	equ	3		;Three serial ports
CPU_SER		equ	0		;CPU serial port is port 0
UARTA		equ	1		;UART A handles serial port 1
UARTB		equ	2		;UART B handles serial port 2
UARTA_INT	equ	40h		;Enable UARTA Tx Interrupt
UARTB_INT	equ	80h		;Enable UARTB Tx Interrupt
EXTINT_BIT	equ	2		;Bit to check in ioport 2 for ext int

;	tx_status bits
XMITOFF		equ	1		;tx_status bit shows no data
XOFFSTS		equ	2		;tx_status bit shows XOFF

;	XON/XOFF stuff
XON		equ	11h		;XON character
XOFF		equ	13h		;XOFF character


;	Serial initialization bits
BAUD_MASK	equ	07		;Baud rate should be 4 LSB's, but
					; we're only using 3 bits now
PTY_MASK	equ	30h		;Parity is bits 4,5
BIT8		equ	40h		;Bit 6 on for 8 bit, else 7 bit
BIT7		equ	0		;7 bit characters
STOP2		equ	80h		;Bit 7 on for 2 stop bits, else 1
STOP1		equ	0		;1 stop bit
PTY_LEN_STOP	equ	0f0h		;Parity, stop, len in bits 4-7
NO_PTY		equ	0		;No parity
EVEN_PTY	equ	10h		;Even parity
ODD_PTY		equ	20h		;Odd parity

			;CPU Serial port stuff
SER_PEN		equ	04h		;SPCON: Enable even parity
SER_REN		equ	08h		;SPCON: Enable receiver
SER_9BIT	equ	10h		;SPCON: Set 9th bit of data
SER_OE		equ	04h		;SPSTAT: Overrun error
SER_TXE		equ	08h		;SPSTAT: Transmitter empty
SER_TXE_BIT	equ	3		;SPSTAT: Transmitter empty
SER_FE		equ	10h		;SPSTAT: Framing error
SER_TI		equ	20h		;SPSTAT: Transmitter ready int
SER_TI_BIT	equ	5		;SPSTAT: Transmitter ready int
SER_RI		equ	40h		;SPSTAT: Received char int
SER_RI_BIT	equ	6		;SPSTAT: Received char int
SER_RB8		equ	80h		;SPSTAT: Rcv parity err or 9th bit
SER_MODE1	equ	1		;SPCON: Serial mode 1

			;82C52 UART stuff
RTS		equ	01h		;RTS ctrl bit in MCR
DTR		equ	02h		;DTR ctrl bit in MCR
UART_INTEN	equ	04h		;Int enbl bit in MCR
UART_RCVEN	equ	20h		;Receive enbl bit in MCR
UART_MDMINT	equ	40h		;Modem int enbl bit in MCR
PTY_ERR		equ	01h		;Parity error bit in MSR
FRAME_ERR	equ	02h		;Framing error bit in MSR
OVERRUN		equ	04h		;Overrun error bit in MSR
BREAK		equ	08h		;Break received bit in MSR
STS_CHANGE	equ	10h		;Modem status changed bit in MSR
XMIT_DONE	equ	20h		;Transmission complete bit in MSR
XMIT_DONE_BIT	equ	5		;Transmission complete bit in MSR
XMIT_RDY	equ	40h		;Transmit buffer empty bit in MSR
XMIT_RDY_BIT	equ	6		;Transmit buffer empty bit in MSR
RCV_RDY		equ	80h		;Received data ready bit in MSR
RCV_RDY_BIT	equ	7		;Received data ready bit in MSR


;****************************************************************************
;* 80C196 Definitions
;* Things that aren't in 8096.inc, but should be
;
;	Interrupt Mask/Pending Bits
TIMER_OVF	equ	01h		; IMASK Timer overflow
AD_DONE		equ	02h		; IMASK A/D Done
HSI		equ	04h		; IMASK HSI Data
HSO		equ	08h		; IMASK HSO
HSI0		equ	10h		; IMASK HSI.0 Pin
SW_TIMER	equ	20h		; IMASK Software timer
SER_INT		equ	40h		; IMASK Serial port
P07		equ	80h		; IMASK External Int (8096 compat)
XMIT		equ	01h		; IMASK1 Serial Xmit
RCV		equ	02h		; IMASK1 Serial Received Data
HSI4		equ	04h		; IMASK1 HSI half full
T2_CAP		equ	08h		; IMASK1 T2 Capture
T2_OVF		equ	10h		; IMASK1 T2 Overflow
EXTERNAL_INT	equ	20h		; IMASK1 External Int pin
FIFO_FULL	equ	40h		; IMASK1 HSI FIFO full
NMI		equ	80h		; IMASK1 NMI


;*****************************************************************************
; Interrupt bits in PIAA-A
;

UARTB_TBRE_INT	equ	0		;UART B Transmit Buffer Register Empty
UARTB_DR_INT	equ	1		;UART B Data Ready
UARTB_INT_BIT	equ	2		;Interrupt line from UART B
UARTA_TBRE_INT	equ	3		;UART A Transmit Buffer Register Empty
UARTA_DR_INT	equ	4		;UART A Data Ready
UARTA_INT_BIT	equ	5		;Interrupt line from UART A
PIAA_IRQ	equ	6		;Int req line from PIAA's (wire OR'd)
LBAT_INT	equ	7		;Low battery interrupt from DC/DC conv


;************************************************
;* I/O for OASIS controller			*
;* The I/O locations are assigned in oregs.s	*
;

EXTRN	relay_enbl:WORD, bank_port:BYTE, oasis_ctrl:BYTE

EXTRN	uarta_data:BYTE, uarta_ucr:BYTE, uarta_usr:BYTE, uarta_mcr:BYTE
EXTRN	uarta_brsr:BYTE, uarta_msr:BYTE

EXTRN	uartb_data:BYTE, uartb_ucr:BYTE, uartb_usr:BYTE, uartb_mcr:BYTE
EXTRN	uartb_brsr:BYTE, uartb_msr:BYTE

EXTRN	piaa_p1da:BYTE, piaa_p2da:BYTE, piaa_pda:BYTE, piaa_pdb:BYTE
EXTRN	piaa_pdc:BYTE, piaa_ddra:BYTE, piaa_ddrb:BYTE, piaa_ddrc:BYTE
EXTRN	piaa_cra:BYTE, piaa_crb:BYTE, piaa_fsr:BYTE, piaa_p1db:BYTE
EXTRN	piaa_p2db:BYTE, piaa_hsr:BYTE, piaa_hwr:BYTE

EXTRN	piab_p1da:BYTE, piab_p2da:BYTE, piab_pda:BYTE, piab_pdb:BYTE
EXTRN	piab_pdc:BYTE, piab_ddra:BYTE, piab_ddrb:BYTE, piab_ddrc:BYTE
EXTRN	piab_cra:BYTE, piab_crb:BYTE, piab_fsr:BYTE, piab_p1db:BYTE
EXTRN	piab_p2db:BYTE, piab_hsr:BYTE, piab_hwr:BYTE

$LIST
