/****************************************************************************/
/* Copyright 1991-1999 MBARI						    */
/****************************************************************************/
/* $Header: garmin.h,v 4.4 2001/06/19 12:13:38 oasisa Exp $			    */
/* Summary  : Definitions for the Magellan 10 channel GPS board		    */
/* Filename : gps10.h							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 03/31/99							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 31mar99 rah - created						    */
/* $Log:	garmin.h,v $
 * Revision 4.4  2001/06/19  12:13:38  12:13:38  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:43:31  11:43:31  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.3  99/06/16  10:36:05  10:36:05  bobh (Bob Herlien)
 * Mar/May '99 Deployments of M3/M2
 * 
*/
/****************************************************************************/

#ifndef INCgarminh
#define INCgarminh	1


/********************************/
/* Misceallaneous defines	*/
/********************************/
					/************************************/
#define GPS_BUFSIZE	128		/* Buffer size for GPS messages	    */
#define GPS_SAMPLES	300		/* Max number GPS samples to take   */
#define LATLONG_ERR	LONG_MAX	/* Indicates bad GPSsample	    */
#define GPS_ERR_THRESH	100		/* Allow sample as good if < 10m off*/
					/* We compare variance, is squared  */
#define GARMIN_FMT	1		/* Format specifier for Garmin	    */
					/************************************/
					/* Driver flags used by GPS driver  */
#define GPS_IN_USE	0x80		/* GPS already in use		    */
#define GPS_TRACKING	0x40		/* GPS getting good fixes	    */
					/************************************/

/****************************************/
/* Structures for position and logging	*/
/****************************************/

typedef struct				/************************************/
{					/* One GPS position/velocity sample */
    Int32	gps_lat;		/* Units of 10^-4 minutes North	    */
    Int32	gps_long;		/* Units of 10^-4 minutes East	    */
} GpsSample;				/************************************/

typedef struct				/************************************/
{					/* GPSLogRec - GPS Position record  */
    Nat16	gps_fmt;		/* Format			    */
    Nat16	gps_avgSamples;		/* Number of samples in mean lat/lon*/
    Int32	gps_lat;		/* Units of 10^-4 minutes North	    */
    Int32	gps_long;		/* Units of 10^-4 minutes East	    */
    Nat32	gps_pos_err;		/* Variance of position (meters^2)  */
    Nat16	gps_ontime;		/* Time to get GPS samples	    */
    Nat16	gps_diffSamples;	/* Number of samples that were diff */
    Nat16	gps_hdop;		/* Last HDOP			    */
    Word	gps_status;		/* Status word			    */
} GpsLogRec;				/************************************/

typedef struct				/************************************/
{					/* GpsStruct - struct to hold samples*/
    Nat16	gps_totSamples;		/* Total num samples currently taken*/
    GpsLogRec	gps_logRec;		/* The data to log		    */
    char	gps_buffer[GPS_BUFSIZE];/* Buffer to read data into	    */
    GpsSample	gps_sample[1];		/* Array of GpsSamples		    */
} GpsStruct;				/************************************/

#endif /* INCgarminh */
