$NOLIST

;************************************************************************
;* Copyright 1994 MBARI							*
;************************************************************************
;* Summary  : Definitions for Disk I/O in OASIS mooring controller	*
;* Filename : disk.inc							*
;* Author   : Robert Herlien (rah)					*
;* Project  : OASIS Mooring						*
;* Version  : 1.0							*
;* Created  : 12/21/94							*
;*									    *
;* MBARI provides this documentation and code "as is", with no warranty,    *
;* express or implied, of its quality or consistency. It is provided without*
;* support and without obligation on the part of the Monterey Bay Aquarium  *
;* Research Institute to assist in its use, correction, modification, or    *
;* enhancement. This information should not be published or distributed to  *
;* third parties without specific written permission from MBARI.            *
;*									    *
;************************************************************************
;* Modification History:						*
;* 21dec94 rah - created						*
;************************************************************************

;***********************************************************************
;* Disk port addresses are output onto PIAB port C, along with read/write
;*   strobes and the power on/off bit
;***********************************************************************
;  Port A - D07 - D00
;  Port B - D15 - D08
;  Port C Bit 0 - DA0
;	  Bit 1 - DA1
;	  Bit 2 - DA2
;	  Bit 3 - CS1Fx/
;	  Bit 4 - CS3Fx/
;	  Bit 5 - DIOR/
;	  Bit 6 - Power
;	  Bit 7 - DIOW/
;***********************************************************************

DSK_PWRON	equ	0f8h		;Power on, all strobes off
DSK_QUIET	equ	0ffh		;All strobes off
DSK_PWROFF	equ	0		;Power off, keep I/O bits at ground

DSK_RD_STROBE	equ	0dfh		;Mask for read strobe on
DSK_WRT_STROBE	equ	07fh		;Mask for write strobe on
DSK_CS1_STROBE	equ	0f7h		;Mask for CS1Fx strobe on
DSK_CS3_STROBE	equ	0efh		;Mask for CS3Fx strobe on
DSK_PORT_MASK	equ	0e0h		;Mask to turn off rd/write strobes

DSK_DATA	equ	0f0h		;Data port (16 bits)
DSK_ERROR	equ	0f1h		;Error port
DSK_FEATURES	equ	0f1h		;Features port
DSK_SECT_CNT	equ	0f2h		;Sector count port
DSK_SECTOR	equ	0f3h		;Sector number port
DSK_CYL_LO	equ	0f4h		;Cylinder number (low)
DSK_CYL_HI	equ	0f5h		;Cylinder number (high)
DSK_DRV_HEAD	equ	0f6h		;Drive/head port
DSK_STATUS	equ	0f7h		;Status port
DSK_COMMAND	equ	0f7h		;Command port

DSK_ALT_STATUS	equ	0eeh		;Alternate status port
DSK_CONTROL	equ	0eeh		;Control port
DSK_ADDRESS	equ	0efh		;Address port


;*********************************
;* Bit definitions in disk ports
;*********************************

DSK_BUSY_BIT	equ	80h		;Busy bit in status register

$LIST
