/************************************************************************/
/* Copyright 1994 MBARI							*/
/************************************************************************/
/* $Header: disk.h,v 4.4 2001/06/19 12:13:14 oasisa Exp $			*/
/* Summary  : Definitions for the Kittyhawk IDE disk drive		*/
/* Filename : disk.h							*/
/* Author   : Robert Herlien (rah)					*/
/* Project  : OASIS Mooring						*/
/* $Revision: 4.4 $							*/
/* Created  : 12/21/94							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 21dec94 rah - created						*/
/* $Log:	disk.h,v $
 * Revision 4.4  2001/06/19  12:13:14  12:13:14  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:43:06  11:43:06  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.4  96/06/18  15:24:06  15:24:06  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
 * Revision 3.2  95/04/11  14:09:40  14:09:40  hebo (Bob Herlien)
 * Drifter Deployment on IronEx
 * 
*/
/************************************************************************/

#ifndef INCdiskh
#define INCdiskh	1

/****************************************/
/* Miscellaneous disk defines		*/
/****************************************/

#define DISK_WRITE_BLKS	16		/* Write 256K to disk at a time	*/
#define SECTOR_OFFSET	16		/* Reserve first 8K of disk	*/
#define SECTOR_SIZE	512		/* Disk sector size		*/
#define SECTOR_SHFT	9		/* Log2 of sector size		*/

#define BLK_TO_SECT_SHFT (BLK_SHFT - SECTOR_SHFT)
#define SECTORS_PER_BLK	(1 << BLK_TO_SECT_SHFT)
#define DISK_TIMEOUT		15
#define DISK_ID_TIMEOUT		15
#define DISK_DRQ_TIMEOUT	3
#define DISK_STDBY_TIMEOUT	3

#define RW_BUFFER	(PERM_RAM + PERM_RAM_SIZE)	/* ID & rd/wrt buffer*/


/************************************************************************/
/*	 	Error Return Codes					*/
/* If a disk operation succeeds, it returns OK.  If it fails because	*/
/* the ERR bit in the status register is set, it returns the status	*/
/* register in the high byte and the error register in the low byte.	*/
/* Other failures are described in the following defines.		*/
/************************************************************************/

#define DSK_NOT_INIT	0x8000		/* Not yet initialized		*/
#define	NO_SPACE	0x8001		/* No room on disk or malloc error*/
#define DSK_NOT_READY	0x8002		/* No ready bit			*/
#define DSK_BUSY	0x8003		/* Busy bit never cleared	*/
#define DSK_NO_DRQ	0x8004		/* Never got Data Request	*/
#define DSK_BAD_PARMS	0x8005		/* Bad parameters from ID Drive	*/


/****************************************/
/* Disk Commands to the command port	*/
/****************************************/

#define IDENTIFY_DRIVE	0xec
#define RECALIBRATE	0x10
#define SEEK		0x70
#define READ_SECTOR	0x20
#define WRITE_SECTOR	0x30
#define VERIFY_SECTORS	0x40
#define FORMAT		0x50
#define DIAGNOSTIC	0x90
					/* Two byte commands		*/
#define STANDBY_1	0x96
#define STANDBY_2	0xe2
#define SLEEP_1		0x99
#define SLEEP_2		0xe6


/****************************************/
/* Bits in status port			*/
/****************************************/

#define BUSY_BIT	0x80
#define READY_BIT	0x40
#define WRITE_FAULT_BIT	0x20
#define SEEK_CPLT_BIT	0x10
#define DRQ_BIT		0x08
#define ERROR_BIT	0x01


/************************************************/
/* Miscellaneous Command and Control Defines	*/
/************************************************/

#define CONTROL_NORMAL	0x0a		/* HS3EN set, SRST and IEN inactive*/
#define CONTROL_RESET	0x0e		/* HS3EN and SRST set, IEN inactive*/
#define DRIVE_BYTE	0xa0		/* OR with head nmbr for drv/head  */


/************************************************************************/
/* Disk port addresses are output onto PIAB port C, along with read/write*/
/*   strobes and the power on/off bit					*/
/************************************************************************/
/*  Port A - D07 - D00							*/
/*  Port B - D15 - D08							*/
/*  Port C Bit 0 - DA0							*/
/*	  Bit 1 - DA1							*/
/*	  Bit 2 - DA2							*/
/*	  Bit 3 - CS1Fx/						*/
/*	  Bit 4 - CS3Fx/						*/
/*	  Bit 5 - DIOR/							*/
/*	  Bit 6 - Power							*/
/*	  Bit 7 - DIOW/							*/
/************************************************************************/

#define DSK_PWRON	0xf8		/* Power on, all strobes off	*/
#define DSK_QUIET	DISK_PWRON	/* All strobes off		*/
#define DSK_PWROFF	0		/* Power off, keep I/O bits at gnd*/

#define DSK_DATA	0xf0		/* Data port (16 bits)		*/
#define DSK_ERROR	0xf1		/* Error port			*/
#define DSK_FEATURES	0xf1		/* Features port		*/
#define DSK_SECT_CNT	0xf2		/* Sector count port		*/
#define DSK_SECTOR	0xf3		/* Sector number port		*/
#define DSK_CYL_LO	0xf4		/* Cylinder number (low)	*/
#define DSK_CYL_HI	0xf5		/* Cylinder number (high)	*/
#define DSK_DRV_HEAD	0xf6		/* Drive/head port		*/
#define DSK_STATUS	0xf7		/* Status port			*/
#define DSK_COMMAND	0xf7		/* Command port			*/

#define DSK_ALT_STATUS	0xee		/* Alternate status port	*/
#define DSK_CONTROL	0xee		/* Control port			*/
#define DSK_ADDRESS	0xef		/* Address port			*/


/****************************************/
/* External Functions in diskio.s	*/
/****************************************/

Extern Word	disk_status( Void );
Extern Word	disk_alt_status( Void );
Extern Errno	disk_error( Void );
Extern Void	disk_command( Nat16 cmd );
Extern Nat16	disk_read_port( Nat16 port );
Extern Void	disk_write_port( Nat16 port, Nat16 value );
Extern Void	disk_read_buffer( Nat16 bank, Byte *dst );
Extern Void	disk_write_buffer( Nat16 bank, Byte *src );

#endif	/* INCdiskh */
