/************************************************************************/
/* Copyright 1997 MBARI							*/
/************************************************************************/
/* $Header: argfilter.c,v 2.8 98/03/17 11:11:47 bobh Exp $		    */
/* Summary  : Program to filter ARGOS messages for one PTT number	*/
/* Filename : argfilter.c						*/
/* Author   : Bob Herlien (rah)						*/
/* Project  : OASIS							*/
/* Version  : 1.0							*/
/* Created  : 01/07/97							*/
/************************************************************************/
/* Modification History:						*/
/* 7jan97 rah - created							*/
/* $Log:	argfilter.c,v $
 * Revision 2.8  98/03/17  11:11:47  11:11:47  bobh (Bob Herlien)
 * Archiving sources prior to porting to DOS/Windows
 * 
 * Revision 1.1  97/10/27  09:53:19  09:53:19  bobh (Bob Herlien)
 * Initial revision
 * 
*/
/************************************************************************/

#include <stdio.h>			/* Unix standard I/O		*/
#include <mbariTypes.h>			/* MBARI standard types		*/
#include <mbariConst.h>			/* MBARI standard constants	*/

#define DEFAULT_PTT_NUM 11909
#define MAX_TARGETS	16
#define BUFSIZE		1024


/********************************/
/*	Module Local Data	*/
/********************************/

MLocal Int32		numTargetPtts = 0;
MLocal Int32		targetPtts[MAX_TARGETS];


/********************************/
/*	Forward Declarations	*/
/********************************/

MBool	processCommandLine ( Int32 argc, char **argv );
MBool	isTargetPtt( Int32 pttNum );


/************************************************************************/
/* Function    : main							*/
/* Purpose     : Main routine						*/
/* Inputs      : argc, argv						*/
/* Outputs     : Integer, 0 for success, 1 for failure			*/
/************************************************************************/
	Int32
main( Int32 argc, char **argv )
{
    Reg Int32		currentPttNum = 0;
    Int32		pttNum, i, unused[12];
    char		c;
    char		buffer[BUFSIZE];

    if ( !processCommandLine(argc, argv) )
	exit( 1 );

    if ( numTargetPtts <= 0 )
    {
	targetPtts[0] = DEFAULT_PTT_NUM;
	numTargetPtts = 1;
    }

    while ( gets(buffer) != NULL )
    {
	if ( sscanf(buffer, " %d-%d-%d %d:%d:%d ID %d",
		     &unused[0], &unused[1], &unused[2], &unused[3],
		     &unused[4], &unused[5], &pttNum) == 7 )
	    currentPttNum = pttNum;

	if ( isTargetPtt(currentPttNum) )
	    puts( buffer );
    }

} /* main() */


/************************************************************************/
/* Function : isTargetPtt						*/
/* Purpose  : Determine whether passed PTT number is one of the target PTTs*/
/* Inputs   : PTT number						*/
/* Outputs  : TRUE if target PTT, else FALSE				*/
/************************************************************************/
	MBool
isTargetPtt( Int32 pttNum )
{
    Reg Int32	i;

    for ( i = 0; i < numTargetPtts; i++ )
	if ( pttNum == targetPtts[i] )
	    return( TRUE );

    return( FALSE );

} /* isTargetPtt() */


/************************************************************************/
/* Function : use_msg							*/
/* Purpose  : Print Usage Message					*/
/* Inputs   : Name of program						*/
/* Outputs  : None							*/
/************************************************************************/
	Void
use_msg( char *s )
{
    fprintf( stderr, "Usage: %s [-n ptt_number] [-n ptt_number] [...]\n" );
    fprintf( stderr, "-n indicates a PTT number to include in filter\n");
    fprintf( stderr, "multiple -n parameters may be included\n");
    fprintf( stderr, "if none specified, default PTT number is %d\n",
	    DEFAULT_PTT_NUM);

} /* use_msg() */


/************************************************************************/
/* Function : processCommandLine					*/
/* Purpose  : Read the arguments from the command line			*/
/* Inputs   : argc, argv from main() routine				*/
/* Outputs  : TRUE if arguments OK, else FALSE				*/
/************************************************************************/
	MBool
processCommandLine ( Int32 argc, char **argv )
{
    Int32	c, i;

    while ( (c = getopt(argc, argv, "n:")) != EOF )
	switch( c )
	{
	  case 'n':
	    if ( ((i = atoi(optarg)) != 0) && (numTargetPtts < MAX_TARGETS) )
		targetPtts[numTargetPtts++] = i;
	    break;

	  default:
	    use_msg( argv[0] );
	    return( FALSE );
	}

    return( TRUE );

} /* processCommandLine() */
