BEGIN	{
	day = 0;
	jdays[0] = 0;		# 1989
	jdays[1] = 365;		# 1990
	jdays[2] = 730;		# 1991
	jdays[3] = 1095;	# 1992
	jdays[4] = 1461;	# 1993
	jdays[5] = 1826;	# 1994
	}

(! /^#/ ) {
	    newday = int($1);
	    if ( (newday != day) && (day != 0) )
            {
		printday(day, year);
		clearday();
		samplenum = $2;
	    }
	    day = newday;
	    year = $9;
	    for ( i = 3; i <= 8; i++ )
		    avg[i] += $i;
	    samples++;
	}
END	{
	    printday(day, year);
	}

function printday(day, year)
{
	printf("%4d %4d", day + jdays[year - 89], samplenum);
	for ( i = 3; i <= 8; i++ )
	    if ( samples > 0 )
		printf( " %6.3f", avg[i]/samples );
	    else
		printf( "  0.0  " );
	    printf( "\n" );
}

function clearday()
{
	for ( i = 0; i <= 8; i++ )
	    avg[i] = 0.0;
	samples = 0;
}
