BEGIN {
    nmsgs = 7;
}

{
    newyear = int($1);
    if ( (newyear % 4) == 0 )
	daysPerYear = 366;
    else
	daysPerYear = 365;

    newday = int(daysPerYear * ($1 - newyear) + 1.5);

    if ( (newday != day) && (day != 0) )
    {
	printday(day, year);

	for ( i = 0; i < nmsgs; i++ )
	    hits[i] = 0;
    }
    day = newday;
    year = newyear;

    hits[$2] += $3;
}

END {
    printday(day, year);
   }

function printday(day, year)
{
    printf("%8.4f %03d  ", year + (day/daysPerYear), day);
    for ( i = 0; i < nmsgs; i++ )
	printf("%3d ", hits[i]);
    printf("\n");
}
