#! /bin/csh
# process.m3 - C Shell script to sort today's M3 data
#   We do this because M3 data arrives out of order
#   Note - not the same as daily processing, which concatenates data
#

set oasis = /oasis
set cfg = $oasis/cfg
set bin = $oasis/bin
set tmp = /oasis/tmp
set nonomatch

set mooring = m3
set file1 = 98134
set file2 = 98135

foreach name (adcp atlas ctd gps oasis pco2 satlantic)
    cd $oasis/$mooring/$name
    foreach file ($file1 $file2)
	if (-e $file) then
	    rm -f $file.tmp1 $file.tmp2
	    grep -v \# $file >> $file.tmp1
	    cp $cfg/$mooring/$name.hdr $file.tmp2
	    sort $file.tmp1 >> $file.tmp2
	    rm -f $file $file.tmp1
	    mv $file.tmp2 $file
	endif
    end
end

foreach name (nitrate)
    cd $oasis/$mooring/$name
    foreach file ($file1 $file2)
	if (-e $file) then
	    rm -f $file.tmp1 $file.tmp2
	    grep -v \# $file >> $file.tmp1
	    cp $cfg/$mooring/$name.hdr $file.tmp2
	    sort -n -k2 $file.tmp1 >> $file.tmp2
	    rm -f $file $file.tmp1
	    mv $file.tmp2 $file
	endif
    end
end
