#! /bin/csh
# process - C Shell script to remove processed OASIS data 
#		and reprocess it all
#

set oasis = /oasis
set cfg = $oasis/cfg
set bin = $oasis/bin
set tmp = /oasis/tmp
set nonomatch

set mooring = m3
cd $oasis/$mooring

foreach name (adcp atlas ctd gps oasis pco2 satlantic)
	rm -f data/$name $tmp/$name.tmp
	cp $cfg/$mooring/$name.hdr data/$name
	foreach year (98 99)
	    @ fullyear = $year + 1900
	    foreach file ($name/$year*)
		awk -f $bin/concat.awk year=$fullyear $file >> $tmp/$name.tmp
	    end
	    sort $tmp/$name.tmp >> data/$name
	    rm -f $tmp/$name.tmp
	end
end

foreach name (nitrate)
	rm -f data/$name data/$name.Z
	cp $cfg/$mooring/$name.hdr data/$name
	foreach file ($name/9*)
		grep -v \# $file | grep -v OASIS >> data/$name
	end
end

foreach mooring (m3)
	cd $oasis/$mooring/data
	awk -f $bin/atlmean.awk atlas > atlas.mean
	awk -f $bin/ctdmean.awk ctd   > ctd.mean
	awk -f $bin/atlmean.trans.awk atlas > atlas.mean.t
	$bin/transpose -if atlas.mean.t -of atlas.transpose
end
