#! /bin/csh
# getm2 - C Shell script to download data from OASIS mooring at M2
#	     and extract the data
#
set oasis = /oasis
set can = m2
set tncaddr = "mbari-5 v mbari-3"

cd $oasis/raw
set noclobber
set noglob
set datafilebase = `date +%y%j`
set failmail = "headley@mbari.org,zorba@mbari.org"

set i = 0
set datafile = $can.$datafilebase.00
while ( -e $datafile )
	@ i++
	set datafile = $can.$datafilebase.`printf "%02d" $i`
end

set errorfile = $oasis/$can/error/$datafile

$oasis/bin/getoasis -a "$tncaddr" -c $can >& $datafile
set rtnsts = $status

if ( $rtnsts ) then
	/bin/mailx -s "Failed OASIS Download" $failmail << !
Download failure of file $datafile 
Return code was $rtnsts
	0 = Success
	1 = Argument error (bad command line arguments)
	2 = Couldn't acquire TNC port (hung download or someone's using port)
	3 = Couldn't connect to OASIS (it's not listening)
	4 = Download error (something broke after it connected)
	5 = Abort error (somebody killed the download)
`date`
!
endif

if ( (-e $datafile) && !(-z $datafile) ) then
	$oasis/bin/extract -n -r $datafile >& $errorfile
endif

if ( -z $errorfile ) \
	rm -f $errorfile
