BEGIN	{
	print("            0     10     20     40     60     80    100    150    200");
	day = 0;
	jdays[0] = 0;		# 1989
	jdays[1] = 365;		# 1990
	jdays[2] = 730;		# 1991
	jdays[3] = 1095;	# 1992
	jdays[4] = 1461;	# 1993
	jdays[5] = 1826;	# 1994
	}

(! /^#/ ) {
	    newday = int($1);
	    if ( (newday != day) && (day != 0) )
	    {
		printday(day, year);
		clearday();
	    }
	    day = newday;
	    year = $26;
	    for ( i = 0; i < 9; i++ )
		if ( $(i+3) > 5.0 )
		{
		    temp[i] += $(i+3);
		    samples[i]++;
		}
	   }

END	{
	    printday(day, year);
	}

function printday(day, year)
{
	printf("%3d %4d", year, day + jdays[year - 89]);
	for ( i = 0; i < 9; i++ )
	    if ( samples[i] > 0 )
		printf( " %6.3f", temp[i]/samples[i] );
	    else
		printf( "  0.0  " );
	printf( "\n" );
}

function clearday()
{
	for ( i = 0; i < 12; i++ )
	{
	    temp[i] = 0.0;
	    samples[i] = 0;
	}
	windu = 0.0;
	windv = 0.0;
	wsamples = 0;
}
