BEGIN	{
	print("Day  Air    SST    T10    T20    T40    T60    T80    T100   T150   T200   T250   T300   WINDU  WINDV");
	day = 0;
	jdays[0] = 0;		# 1989
	jdays[1] = 365;		# 1990
	jdays[2] = 730;		# 1991
	jdays[3] = 1095;	# 1992
	jdays[4] = 1461;	# 1993
	jdays[5] = 1826;	# 1994
	}

(! /^#/ ) {
	    newday = int($1);
	    if ( (newday != day) && (day != 0) )
	    {
		printday(day, year);
		clearday();
	    }
	    day = newday;
	    year = $26;
	    for ( i = 0; i < 12; i++ )
		if ( $(i+3) > 0.5 )
		{
		    temp[i] += $(i+3);
		    samples[i]++;
		}
	    windu += $20;
	    windv += $21;
	    wsamples++;
	   }

END	{
	    printday(day, year);
	}

function printday(day, year)
{
	printf("%4d", day + jdays[year - 89]);
	for ( i = 0; i < 12; i++ )
	    if ( samples[i] > 0 )
		printf( " %6.3f", temp[i]/samples[i] );
	    else
		printf( "  0.0  " );
	if ( wsamples > 0 )
	    printf( " %6.3f %6.3f\n", windu/wsamples, windv/wsamples );
	else
	    printf( "   0.0    0.0\n" );
}

function clearday()
{
	for ( i = 0; i < 12; i++ )
	{
	    temp[i] = 0.0;
	    samples[i] = 0;
	}
	windu = 0.0;
	windv = 0.0;
	wsamples = 0;
}
