#! /bin/csh
# process - C Shell script to remove processed OASIS data 
#		and reprocess it all
#

set oasis = /oasis
set cfg = $oasis/cfg
set bin = $oasis/bin
set tmp = /oasis/tmp
set nonomatch

set mooring = m1
cd $oasis/$mooring

foreach name (specprr)
	rm -f data/$name $tmp/$name.tmp
	cp $cfg/$mooring/$name.hdr data/$name
	foreach year (97)
	    @ fullyear = $year + 1900
	    foreach file ($name/$year*)
		awk -f $bin/concat.awk -v year=$fullyear $file >> $tmp/$name.tmp
	    end
	    sort $tmp/$name.tmp >> data/$name
	    rm -f $tmp/$name.tmp
	end
end

set mooring = m2
cd $oasis/$mooring

foreach name (specprr)
	rm -f data/$name $tmp/$name.tmp
	cp $cfg/$mooring/$name.hdr data/$name
	foreach year (97)
	    @ fullyear = $year + 1900
	    foreach file ($name/$year*)
		awk -f $bin/concat.awk year=$fullyear $file >> $tmp/$name.tmp
	    end
	    sort $tmp/$name.tmp >> data/$name
	    rm -f $tmp/$name.tmp
	end
end
