BEGIN {
	doIt = 0;
	printf("Julian Time   U      V     Speed Direction\n");
      }

(! /^#/ ) {
	time = $1
	lat = $2;
	lon = $3;

        if ( doIt != 0 )
	{
	    deltaLat = (lat - lastLat) * 60.0 * 1852.0;
	    deltaLon = (lon - lastLon) * 60.0 * 1852.0 * cos(lat);
	    deltaT = time - lastTime;
	    v = deltaLat / deltaT;
	    u = deltaLon / deltaT;
	    speed = sqrt( u*u + v*v);
	    direction = 90.0 - (atan2(deltaLat, deltaLon) * 180.0 / 3.141593);
	    while ( direction < 0.0 )
		direction += 360.0;

	    jtime = (time - 788918400) / (24 * 3600) + 1.0;

	    if ( speed < 1.5 ) \
		printf("%10.5f %6.3f %6.3f  %6.3f %6.1f\n", \
		       jtime, u, v, speed, direction);
	}

	lastTime = time;
	lastLat = lat;
	lastLon = lon;
	doIt = 1;
    }
