/* From the HP "Asynchronous Serial Communications Programming Manual"	*/

/* 14 Jan 94, rah	*/

#include <fcntl.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <termio.h>			/* For terminal I/O stuff	    */

#define TTY	"/dev/tty"
#define MAXIT	12
#define SIZEBUF	512
#define MAINERR	1

char	buf[SIZEBUF];
int	bufsize, nbytes, i, tty;

struct termio tnc_term =		/* Termio characteristics for TNC   */
{   IGNPAR | IXON,			/* c_iflag			    */
    OPOST | ONLCR,			/* c_oflag			    */
    B9600 | CS8 | CREAD | CLOCAL,	/* c_cflag			    */
    NOFLSH,				/* c_lflag			    */
    0,					/* c_line, HP has no line disciplines*/
    {0, 0, 0, 0, 0, 10, 0, 0}		/* control chars (1 second timeout) */
};

struct termio tnc_save;		 	/* Place to save terminal charac.   */


int	io_req();
struct sigvec	vec = {io_req, 0, 0};

main()
{
    int		pid, arg;

    if ( (tty = open(TTY, O_RDONLY)) < 0 )
    {
	perror( "Open failed\n" );
	exit( MAINERR );
    }

    sigvector( SIGIO, &vec, 0 );

    pid = getpid();			/* Get process ID		*/
    arg = 1;

    if ( ioctl(tty, TCGETA, tnc_save) < 0 )
    {
	fprintf( stderr, "TCGETA failed\n" );
	close( tty );
	exit( MAINERR );
    }

    if ( ioctl(tty, TCSETA, tnc_term) < 0 )
    {
	fprintf( stderr, "TCSETA failed\n" );
	close( tty );
	exit( MAINERR );
    }
/*
    if ( ioctl(tty, FIOSNBIO, &pid) < 0 )
    {
	perror( "FIOSNBIO failed\n" );
	close( tty );
	exit( MAINERR );
    }
*/
    if ( ioctl(tty, FIOSSAIOOWN, &pid) < 0 )	/* Catch SIGIO signals	*/
    {
	perror( "FIOSSAIOOWN failed\n" );
	close( tty );
	exit( MAINERR );
    }

    if ( ioctl(tty, FIOSSAIOSTAT, &arg) < 0 )	/* Enable Async I/O	*/
    {
	perror( "FIOSSAIOSTAT failed\n" );
	close( tty );
	exit( MAINERR );
    }

    printf( "SIGIO enabled\n" );
    fflush( stdout );

    for( i = 0; i < MAXIT; i++ )		/* Wait for kbd input	*/
    {
	printf( "\nPlease type something on the keyboard " );
	fflush( stdout );
	sigpause( 0L );
    }

    arg = 0;					/* Disable async I/O	*/
    if ( ioctl(tty, FIOSSAIOSTAT, &arg) < 0 )
    {
	perror( "FIOSSAIOSTAT failed\n" );
	close( tty );
	exit( MAINERR );
    }

    if ( ioctl(tty, TCSETA, tnc_save) < 0 )
    {
	fprintf( stderr, "TCSETA failed\n" );
	close( tty );
	exit( MAINERR );
    }

    close( tty );

} /* main() */


/*	Signal Handler		*/
io_req()
{
    int		arg;

    if ( (nbytes = read(tty, buf, SIZEBUF)) > 0 )
    {
	printf("read %d bytes\n", nbytes);
	fwrite(buf, 1, nbytes, stdout);
	fflush( stdout );
    }
    else if ( nbytes == 0 )
    {
	printf("read EOF\n");
	fflush( stdout );
    }
    else if ( nbytes == -1 )
    {
	perror( "Read failed " );
	arg = 0;
	ioctl( tty, FIOSSAIOSTAT, &arg );
	close( tty );
	exit( MAINERR );
    }
}

    
