/*									    */
/* $Header: /home/cvs/oasis3/src/operations/src/jdaynew.c,v 1.1 2003/08/20 19:39:44 headley Exp $ */
/* Copyright 2001 MBARI                                                     */
/* Author: Kent Headley                                                     */
/* $Revision: 1.1 $ */
/* Summary: Compute day of year                                             */
/* Input: 0 or more dates mm/dd/yyyy; Default is current day                */
/* Output: Day of year                                                      */
/* Notes: Compile with -I /usr/include                                      */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/* $Log: jdaynew.c,v $
/* Revision 1.1  2003/08/20 19:39:44  headley
/* no message
/*
 * Revision 1.2  2001/06/19  13:23:52  13:23:52  oasisa (Oasis users)
 * Added header, logs, revision
 * 
*/

#include <stdio.h>
#include <math.h>
#include <time.h>


main(argc,argv)
int argc;
char *argv[];
{
 unsigned IsLeapYear=0;
 int year,month,day;
 int i,j,jday;
 char *wdays[]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
 int mo_days[]={0,31,28,31,30,31,30,31,31,30,31,30,31};
 enum Months{JAN=1,FEB,MAR,APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC};
 struct tm *tp,when;
 time_t wtime;
 
 if (argc<2){
      time(&wtime);
      tp = localtime( &wtime );
      printf("\n%s %02d/%02d/%04d is day %d\n",wdays[tp->tm_wday],tp->tm_mon+1,tp->tm_mday,tp->tm_year+1900,tp->tm_yday+1);
 }else
 for(i=1;i<argc;i++){
  if (sscanf(argv[i],"%d/%d/%d",&month,&day,&year)==3){
      when.tm_mon = month-1;
      when.tm_mday = day;
      when.tm_year = year-1900;
      wtime=mktime(&when);
      printf("\n%s %02d/%02d/%04d is day %d\n",wdays[when.tm_wday],when.tm_mon+1,when.tm_mday,when.tm_year+1900,when.tm_yday+1);
  }
}
printf("Usage: %s mm/dd/yyyy\n\n",argv[0]);
return(0);
}
