/****************************************************************************/
/* Copyright 1991 MBARI                                                     */
/****************************************************************************/
/* $Header: /home/cvs/oasis3/src/operations/src/dos.c,v 1.1 2003/08/20 19:39:43 headley Exp $			    */
/* Summary  : File Handling Routines for `extract`			    */
/* Filename : file.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 1.1 $							    */
/* Created  : 02/05/91							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 14nov96 rah - created						    */
/* $Log: dos.c,v $
/* Revision 1.1  2003/08/20 19:39:43  headley
/* no message
/*
 * Revision 1.1  2001/06/19  13:01:59  13:01:59  oasisa (Oasis users)
 * Initial revision
 * 
*/
/****************************************************************************/

#include <mbariTypes.h>			/* MBARI type definitions	    */
#include <mbariConst.h>			/* MBARI constants		    */
#include <decode.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>


/********************************/
/*	Global Data		*/
/********************************/

Global Int	optind = 1;		/* Option index for getopt()	    */
Global char	*optarg;		/* Option argument for getopt()     */


/************************************************************************/
/* Function    : getopt							*/
/* Purpose     : Get command line option				*/
/* Inputs      : argc, argv, option format				*/
/* Outputs     : Option letter						*/
/************************************************************************/
	Int
getopt( Int argc, char **argv, char *fmt )
{
    Reg char	*p, *fmtptr;

    if ( optind >= argc )
	return( EOF );
    
    p = argv[optind];

    deblank(p);

    if ( *p++ != '-' )
	return( EOF );

    fmtptr = strchr(fmt, *p);

    if ( (*p == ':') || (fmtptr == NULL) )
	return( EOF );

    optind++;
    optarg = p;
    optarg++;
    fmtptr++;
    
    if ( *fmtptr == ':' )
    {
	if ( *optarg == '\0' )
	    optarg = argv[optind++];

	deblank(optarg);
    }    
    return( *p );
    
} /* getopt() */
