# Calibration file for Satlantic Spectroradiometer attached to PRR-600
# Dummy Satlantic file for "B" connector with no instrument plugged in
# File created 12mar97
#
# This is calibration file for one PRR Spectro
# Format of this file was chosen to be consistent with Biospherical cal file
# 
# There is one line of calibration data for each channel as follows:
#  bank chan type name  a  b  c  cmin cmax units
#
# bank:  Bank number, i.e., the address tag for a given bank of channels
# chan:  Channel number
# type:  Type of channel, as follows: 0 = unused, 1 = down irrad, 2 = analog,
#        3 = up radiance, 4 = up irrad, 5 = quadratic, 6 = Old Satlantic cals
#	 7 = New Satlantic cals (b is multiplier) or MCP
#        Once a count is converted to a voltage, via fixed algorithm,
#	 the voltage is converted to given units as follows:
#	 Type 0:       not converted or reported
#	 Types 1 - 4:  value = (volts - c) / b  (a is unused)
#	 Type 5:       value = (a * volts^2) + (b * volts) + c
#	 Type 6:       value = a * (volts - c) / b
#	 Type 7:       value = a * b * (volts - c)
# name:  Name of channel
# a:     Calibration "a" value, unused for types 1-4
# b:     Calibration "b" value
# c:     Calibration "c" value
# cmin:  unused
# cmax:  unused
# units: Units that value decodes into

1  9 7 Lu412  1.0    1.0     0.0  0 5 uwatts/cm2/nm/str
1 10 7 Lu443  1.0    1.0     0.0  0 5 uwatts/cm2/nm/str
1 11 7 Lu490  1.0    1.0     0.0  0 5 uwatts/cm2/nm/str
1 12 7 Lu510  1.0    1.0     0.0  0 5 uwatts/cm2/nm/str
1 13 7 Lu555  1.0    1.0     0.0  0 5 uwatts/cm2/nm/str
1 14 7 Lu670  1.0    1.0     0.0  0 5 uwatts/cm2/nm/str
1 15 7 Lu683  1.0    1.0     0.0  0 5 uwatts/cm2/nm/str
1 16 2 Gnd    1.0    1.0     0.0  0 5 volts
