/****************************************************************************/
/* Copyright 1996 MBARI                                                     */
/****************************************************************************/
/* $Header: ac9.c,v 3.0 99/05/12 10:11:27 bobh Exp $			    */
/* Summary  : AC-9 decode routines for decode.c, extract.c		    */
/* Filename : ac9.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 3.0 $							    */
/* Created  : 04/29/96							    */
/****************************************************************************/
/* Modification History:						    */
/* 29apr96 rah - created						    */
/* $Log:	ac9.c,v $
 * Revision 3.0  99/05/12  10:11:27  10:11:27  bobh (Bob Herlien)
 * Added tstring, misc changes
 * 
 * Revision 2.9  98/08/24  13:45:55  13:45:55  bobh (Bob Herlien)
 * Archiving sources after M2/M3 & Eqpac deployments of 1998
 * 
 * Revision 2.8  98/03/17  11:11:41  11:11:41  bobh (Bob Herlien)
 * Archiving sources prior to porting to DOS/Windows
 * 
 * Revision 2.7  97/09/09  09:52:47  09:52:47  bobh (Bob Herlien)
 * Archiving various changes
 * 
*/
/****************************************************************************/

#include <stdio.h>			/* Standard I/O			    */
#include <mbariTypes.h>			/* MBARI type definitions	    */
#include <mbariConst.h>			/* MBARI constants		    */
#include <decode.h>			/* OASIS controller definitions	    */
#include <time.h>			/* Time				    */


/********************************/
/*	External Functions	*/
/********************************/

Extern Nat16	getIntelword( Byte *p );
Extern Nat32	getIntellong( Byte *p );


/********************************/
/*	Module Local Data	*/
/********************************/

MLocal Int32 countTemp [600] =
{
-2000, -1875, -1750, -1625, -1500, -1375, -1250, -1125, -1000,	-875,
 -750,	-625,  -500,  -375,	 -250,	-125,	  0,   125,	  250,	 375,
  500,	 625,	750,   875,  1000,	1100,  1200,  1299,  1399,	1500,
 1600,	1700,  1799,  1899,  2000,	2099,  2200,  2299,  2400,	2500,
 2599,	2700,  2799,  2900,  3000,	3099,  3200,  3299,  3400,	3500,
 3599,	3700,  3799,  3900,  4000,	4099,  4199,  4300,  4400,	4500,
 4599,	4699,  4800,  4900,  5000,	5099,  5199,  5300,  5400,	5500,
 5599,	5699,  5800,  5900,  6000,	6099,  6199,  6300,  6400,	6500,
 6599,	6699,  6800,  6900,  7000,	7083,  7166,  7250,  7333,	7416,
 7500,	7583,  7666,  7750,  7833,	7916,  8000,  8083,  8166,	8250,
 8333,	8416,  8500,  8583,  8666,	8750,  8833,  8916,  9000,	9100,
 9199,	9300,  9399,  9500,  9600,	9699,  9800,  9899, 10000, 10083,
10166, 10250, 10333, 10416, 10500, 10583, 10666, 10750, 10833, 10916, 
11000, 11071, 11142, 11214, 11285, 11357, 11428, 11500, 11571, 11642, 
11714, 11785, 11857, 11928, 12000, 12083, 12166, 12250, 12333, 12416, 
12500, 12583, 12666, 12750, 12833, 12916, 13000, 13071, 13142, 13214, 
13285, 13357, 13428, 13500, 13571, 13642, 13714, 13785, 13857, 13928, 
14000, 14083, 14166, 14250, 14333, 14416, 14500, 14583, 14666, 14750, 
14833, 14916, 15000, 15071, 15142, 15214, 15285, 15357, 15428, 15500, 
15571, 15642, 15714, 15785, 15857, 15928, 16000, 16071, 16142, 16214, 
16285, 16357, 16428, 16500, 16571, 16642, 16714, 16785, 16857, 16928, 
17000, 17071, 17142, 17214, 17285, 17357, 17428, 17500, 17571, 17642, 
17714, 17785, 17857, 17928, 18000, 18062, 18125, 18187, 18250, 18312, 
18375, 18437, 18500, 18562, 18625, 18687, 18750, 18812, 18875, 18937, 
19000, 19071, 19142, 19214, 19285, 19357, 19428, 19500, 19571, 19642, 
19714, 19785, 19857, 19928, 20000, 20062, 20125, 20187, 20250, 20312, 
20375, 20437, 20500, 20562, 20625, 20687, 20750, 20812, 20875, 20937, 
21000, 21071, 21142, 21214, 21285, 21357, 21428, 21500, 21571, 21642, 
21714, 21785, 21857, 21928, 22000, 22062, 22125, 22187, 22250, 22312, 
22375, 22437, 22500, 22562, 22625, 22687, 22750, 22812, 22875, 22937, 
23000, 23062, 23125, 23187, 23250, 23312, 23375, 23437, 23500, 23562, 
23625, 23687, 23750, 23812, 23875, 23937, 24000, 24062, 24125, 24187, 
24250, 24312, 24375, 24437, 24500, 24562, 24625, 24687, 24750, 24812, 
24875, 24937, 25000, 25055, 25111, 25166, 25222, 25277, 25333, 25388, 
25444, 25500, 25555, 25611, 25666, 25722, 25777, 25833, 25888, 25944, 
26000, 26062, 26125, 26187, 26250, 26312, 26375, 26437, 26500, 26562, 
26625, 26687, 26750, 26812, 26875, 26937, 27000, 27055, 27111, 27166, 
27222, 27277, 27333, 27388, 27444, 27500, 27555, 27611, 27666, 27722, 
27777, 27833, 27888, 27944, 28000, 28055, 28111, 28166, 28222, 28277, 
28333, 28388, 28444, 28500, 28555, 28611, 28666, 28722, 28777, 28833, 
28888, 28944, 29000, 29062, 29125, 29187, 29250, 29312, 29375, 29437, 
29500, 29562, 29625, 29687, 29750, 29812, 29875, 29937, 30000, 30055, 
30111, 30166, 30222, 30277, 30333, 30388, 30444, 30500, 30555, 30611, 
30666, 30722, 30777, 30833, 30888, 30944, 31000, 31055, 31111, 31166, 
31222, 31277, 31333, 31388, 31444, 31500, 31555, 31611, 31666, 31722, 
31777, 31833, 31888, 31944, 32000, 32055, 32111, 32166, 32222, 32277, 
32333, 32388, 32444, 32500, 32555, 32611, 32666, 32722, 32777, 32833, 
32888, 32944, 33000, 33055, 33111, 33166, 33222, 33277, 33333, 33388, 
33444, 33500, 33555, 33611, 33666, 33722, 33777, 33833, 33888, 33944, 
34000, 34052, 34105, 34157, 34210, 34263, 34315, 34368, 34421, 34473, 
34526, 34578, 34631, 34684, 34736, 34789, 34842, 34894, 34947, 35000, 
35052, 35105, 35157, 35210, 35263, 35315, 35368, 35421, 35473, 35526, 
35578, 35631, 35684, 35736, 35789, 35842, 35894, 35947, 36000, 36052, 
36105, 36157, 36210, 36263, 36315, 36368, 36421, 36473, 36526, 36578, 
36631, 36684, 36736, 36789, 36842, 36894, 36947, 37000, 37052, 37105, 
37157, 37210, 37263, 37315, 37368, 37421, 37473, 37526, 37578, 37631, 
37684, 37736, 37789, 37842, 37894, 37947, 38000, 38052, 38105, 38157, 
38210, 38263, 38315, 38368, 38421, 38473, 38526, 38578, 38631, 38684, 
38736, 38789, 38842, 38894, 38947, 39000, 39052, 39105, 39157, 39210, 
39263, 39315, 39368, 39421, 39473, 39526, 39578, 39631, 39684, 39736
};


/************************************************************************/
/* Function    : decode_ac9_temp					*/
/* Purpose     : Decode AC-9 Temperature				*/
/* Inputs      : AC-9 Temperature count					*/
/* Outputs     : AC-9 Temperature					*/
/************************************************************************/
	Flt64
decode_ac9_temp( Int32 count )
{
    count = count - 179;
 
    if (count < 0)
	return (countTemp[0] / (double)1000.0);

    if (count > 599)
	return (countTemp[599] / (double)1000.0);

    return (countTemp[count] / (double)1000.0);

} /* decode_ac9_temp() */


/************************************************************************/
/* Function    : decode_ac9						*/
/* Purpose     : Decode AC-9 information				*/
/* Inputs      : Pointer to AC-9 data, length, ptr to return struct	*/
/* Outputs     : OK or SIZE_ERR						*/
/************************************************************************/
	Status
decode_ac9( Ac9Data *dp, Int len, Ac9Decode *ac9p )
{
    Reg Nat32	i, signal, ref;
    Int32	temp;

    if ( len < (Int)(sizeof(Ac9Data) - sizeof(Nat16)) )
	return( SIZE_ERR );

    ac9p->ac9_samples = getIntelword( (Byte *)&dp->ac9_samples );

    for ( i = 0; i < AC9_CHANS; i++ )
    {
	signal = getIntellong((Byte *)&dp->ac9_data[i]);
	ref = getIntellong((Byte *)&dp->ac9_ref[i]);

	ac9p->ac9_value[i] = ((double)signal / (double)ref) / 10.0;
    }

    temp = getIntellong((Byte *)&dp->ac9_temp);

    if ( ac9p->ac9_samples > 0 )
	temp /= ac9p->ac9_samples;

    ac9p->ac9_temp = decode_ac9_temp( temp );
	
    return( OK );

} /* decode_ac9() */
