/****************************************************************************/
/* Copyright 1998 MBARI                                                     */
/****************************************************************************/
/* $Header: gf.c,v 3.1 2001/06/19 13:12:11 oasisa Exp $			    */
/* Summary  : Ground Fault decode routines for decode.c, extract.c	    */
/* Filename : gf.c							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 3.1 $							    */
/* Created  : 12 june 1998						    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 12jun98 rah - created						    */
/* $Log:	gf.c,v $
 * Revision 3.1  2001/06/19  13:12:11  13:12:11  oasisa (Oasis users)
 *  Periodic Update 6/19/2001 (klh)
 * 
 * Revision 3.0  99/05/12  10:11:32  10:11:32  bobh (Bob Herlien)
 * Added tstring, misc changes
 * 
 * Revision 2.9  98/08/24  13:46:01  13:46:01  bobh (Bob Herlien)
 * Archiving sources after M2/M3 & Eqpac deployments of 1998
 * 
*/
/****************************************************************************/

#include <stdio.h>			/* Standard I/O			    */
#include <mbariTypes.h>			/* MBARI type definitions	    */
#include <mbariConst.h>			/* MBARI constants		    */
#include <decode.h>			/* OASIS controller definitions	    */
#include <string.h>			/* For strncpy			    */


/********************************/
/*	External Functions	*/
/********************************/

Extern Nat16	getMotword( Byte *p ); /* Get word in Motoroloa format	    */


/************************************************************************/
/* Function    : read_gf_cal						*/
/* Purpose     : Read Ground Fault calibration file			*/
/* Inputs      : Name of file, ptr to calibr struct			*/
/* Outputs     : OK or ERROR						*/
/************************************************************************/
	Status
read_gf_cal( char *fileName, GndFltCal *gfp )
{
    FILE		*fp;
    Reg Int		calNum;
    Reg GndFltCal	*gfPtr;
    Int			bufOffset;
    char		buff[256];

    for ( calNum = 0, gfPtr = gfp; calNum < MAX_GF_CALS; calNum++, gfPtr++ )
    {						/* Init cal struct	*/
	bzero( gfPtr, sizeof(GndFltCal) );
	gfPtr->cal_offset = 0.0;
	gfPtr->cal_divisor = 0.0;
	gfPtr->cal_valid = FALSE;
    }

    if ( (fp = fopen(fileName, "rb")) == (FILE *)NULL )
	return( ERROR );

    gfPtr = gfp;
    for ( calNum = 0; (calNum < MAX_GF_CALS) && 
	 (fgets(buff, sizeof(buff), fp) != NULL); )
    {
	if ( sscanf(buff, "%d %lg %lg %s%n ", &gfPtr->raw_offset,
		    &gfPtr->cal_offset, &gfPtr->cal_divisor, 
		    &gfPtr->units, &bufOffset) >= 4 )
	{
	    gfPtr->cal_valid = TRUE;
	    if ( buff[strlen(buff)-1] == '\n' )
		buff[strlen(buff)-1] = '\0';
	    strncpy( gfPtr->ident, &buff[bufOffset], GFIDENTLEN );
	    gfPtr++;
	    calNum++;
	}
    }

    fclose( fp );
    return( OK );

} /* read_gf_cal() */
