/************************************************************************/
/* Copyright 1998 MBARI							*/
/************************************************************************/
/* $Header: ymodem.h,v 4.4 2001/06/19 12:16:23 oasisa Exp $			*/
/* Summary  : Definitions for YModem Protocol				*/
/* Filename : ymodem.h							*/
/* Author   : Robert Herlien (rah)					*/
/* Project  : OASIS Mooring						*/
/* $Revision: 4.4 $							*/
/* Created  : 08/20/98							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/* Comment  : Adapted from xmodem program by Steve Grandi, grandi@noao.edu*/
/************************************************************************/
/* Modification History:						*/
/* 20aug98 rah, created							*/
/* $Log:	ymodem.h,v $
 * Revision 4.4  2001/06/19  12:16:23  12:16:23  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:45:23  11:45:23  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.3  99/06/16  10:21:30  10:21:30  bobh (Bob Herlien)
 * Mar/May '99 Deployments of M3/M2
 * 
*/
/************************************************************************/

#ifndef INCymodemh
#define INCymodemh		1

/*  ASCII Constants  */
#define      SOH  	001 
#define	     STX	002
#define	     ETX	003
#define      EOT	004
#define	     ENQ	005
#define      ACK  	006
#define	     LF		012   /* Unix LF/NL */
#define	     CR		015  
#define      NAK  	025
#define	     SYN	026
#define	     CAN	030
#define	     ESC	033

/* Protocol flags	*/
#define	KPKT	1		/* Use 1K packets		*/
#define	CRCFLAG	2		/* Use CRC			*/
#define	GFLAG	4		/* Use YModem-G			*/


/*  XMODEM Constants  */
#define      ERRORMAX  	10    /* maximum errors tolerated while transferring a packet */
#define      NAKMAX	30    /* maximum times to wait for initial NAK when sending */
#define      RESYNCMAX	30    /* maximum times to wait after file name pkt */
#define      RETRYMAX  	5     /* maximum retries to be made certain handshaking routines */
#define      EOTMAX	10    /* maximum times sender will send an EOT to end transfer */
#define      CRCCHR	'C'   /* CRC request character */
#define      KCHR	'K'   /* 1K block request character */
#define      GCHR	'G'   /* Ymodem-G request character */
#define	     SMPKTSIZE	128   /* Size of small packets (orig Xmodem) */
#define	     LGPKTSIZE	1024  /* Size of large packets (ymodem)	*/
#define	     YBUFSIZE	LGPKTSIZE

#endif /* INCymodemh */
