/****************************************************************************/
/* Copyright 1991 MBARI                                                     */
/****************************************************************************/
/* $Header: usrcmds.h,v 4.4 2001/06/19 12:16:17 oasisa Exp $		    */
/* Summary  : User command definitions for OASIS mooring controller   	    */
/* Filename : usrcmds.h							    */
/* Author   : Robert Herlien (rah)					    */
/* Project  : OASIS Mooring						    */
/* $Revision: 4.4 $							    */
/* Created  : 06/17/91							    */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/****************************************************************************/
/* Modification History:						    */
/* 17jun91 rah - created						    */
/* $Log:	usrcmds.h,v $
 * Revision 4.4  2001/06/19  12:16:17  12:16:17  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:45:14  11:45:14  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 4.3  99/06/16  10:21:26  10:21:26  bobh (Bob Herlien)
 * Mar/May '99 Deployments of M3/M2
 * 
 * Revision 3.9  97/10/29  16:03:41  16:03:41  bobh (Bob Herlien)
 * EqPac Deployment of Nov 1997
 * 
 * Revision 3.4  96/06/18  15:24:06  15:24:06  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
 * Revision 3.1  95/03/09  19:30:50  19:30:50  hebo (Bob Herlien)
 * March '95 Deployment of M1A
 * 
 * Revision 3.0  95/02/21  18:42:35  18:42:35  hebo (Bob Herlien)
 * February '95 Deployment
 * 
 * Revision 2.5  94/01/11  17:42:48  17:42:48  hebo (Bob Herlien)
 * Fixed bug in "getlog", changed PRR format
 * 
 * Revision 2.4  93/10/29  11:12:39  11:12:39  hebo (Bob Herlien)
 * November 1993 Deployment
 * 
 * Revision 2.0  92/08/26  10:37:41  10:37:41  hebo (Bob Herlien)
 * August 1992 Deployment
 * 
 * Revision 1.3  92/03/03  17:12:44  17:12:44  hebo (Bob Herlien 408-647-3748)
 * New defaults, restart check, perm power stuff, analog command
 * 
 * 
*/
/****************************************************************************/

#define	NPARMS	3		/* Max number of parms for user function*/

typedef struct			/****************************************/
{				/* Structure for function table		*/
    char	*fe_cs;		/* Command string			*/
    char	*fe_info;	/* Information for help screen		*/
    Int16	(*fe_cmd)();	/* Pointer to function to impl. command	*/
    Nat16	fe_parmtype[NPARMS]; /* Parameter types			*/
} FuncEntry;			/****************************************/
				/* Parameter types			*/
#define NOPARM	0		/* No corresponding parameter		*/
#define	STRING	1		/* String, until next delimiter		*/
#define	ALL	2		/* Parameter is rest command string	*/
#define	DEC	3		/* Number, default radix is decimal	*/
#define	HEX	4		/* Number, default radix is hexadecimal */
				/****************************************/

typedef struct func_node FuncNode; /* One node in function linked list	*/

struct func_node		/****************************************/
{				/* Structure for function table		*/
    FuncNode	*func_next;	/* For linked list			*/
    FuncNode	*func_prev;	/* For linked list			*/
    char	*fn_cs;		/* Command string			*/
    char	*fn_info;	/* Information for help screen		*/
    Int16	(*fn_cmd)();	/* Pointer to function to impl. command	*/
    Nat16	fn_parmtype[NPARMS]; /* Parameter types			*/
};				/****************************************/

#define FN_NULL	((FuncNode *)0)


/********************************************************/
/*	External Functions used in Command Table	*/
/********************************************************/
Extern Int16	help(Void);
Extern Int16	analog( Nat16, Nat16 );
Extern Int16	connect(Nat16, char *, Nat16, Nat16, Byte *);
Extern Int16	display(Nat16, Nat16, Nat16, Nat16);
Extern Int16	quit(Void);
Extern Int16	set(Nat16, Byte *, Nat16);
Extern Int16	set_string(Nat16, char *, char *);
Extern Int16	params(Nat16, char *, char *);
Extern Int16	tnc_cmd(Nat16, char *, Nat16, Nat16, Byte *);
Extern Int16	reset(Nat16, char *, Nat16);
Extern Int16	time(Nat16, char *);
Extern Int16	usr_power( Nat16, Nat16 );
Extern Int16	getlog(Nat16, Nat16, Nat16, Nat16);
Extern Int16	dump(Nat16, Nat16, Nat16);
Extern Int16	getdata(Void);
Extern Int16	getlognmbrs(Void);
Extern Int16	drvparms(Nat16, char *, Nat16, Nat16, Byte *);
Extern Int16	drvadd(Nat16, char *, Void (*)(), MBool (*)(), Byte *);
Extern Int16	drvdel(Nat16, char *);
Extern Int16	load(Nat16, Nat16, Nat16, Nat16, Byte *);
Extern Int16	aux(Nat16, char *, Nat16, Nat16);
Extern Int16	init(Nat16, char *, Nat16, Nat16);
Extern Int16	sync(Nat16, char *, Nat16, Nat16);
Extern Int16	cmdAdd( Nat16 pmask, char *name, Int16 (*func)(),
			char *help, Byte *buffer );
#ifdef TNC
Extern Int16	radiomsg(Nat16, char *);
#endif
#ifdef INCLUDE_SHUTCAL
Extern Int16	shutCal( Nat16 pmask, char *name );
#endif


/********************************/
/*	User Command Table	*/
/********************************/
					/************************************/
const FuncEntry functbl[] =		/* User Interface Function Table    */
{					/*				    */
  {"ANALOG","Read analog channel",	/* Read analog channel		    */
    analog, DEC, NOPARM, NOPARM},
  {"CON","Connect to instrument", 	/* Connect			    */
    connect, STRING, NOPARM, NOPARM},
  {"AUX","Do Driver Aux function",	/* Perform driver aux function	    */
    aux, STRING, DEC, DEC },		/* Drvr name, time, parm	    */
  {"INIT","Initialize Instrument",	/* Initialize instrument	    */
    init, STRING, DEC, DEC },		/* Drvr name, time, parm	    */
  {"SYNC","Sync Instrument",		/* Sync driver 			    */
    sync, STRING, DEC, DEC },		/* Drvr name, time, parm	    */
  {"CMDADD","Add a user command",	/* Add a function to command list   */
    cmdAdd, STRING, HEX, ALL },
  {"D","Display Memory",		/* Display Memory		    */
    display, HEX, HEX, HEX },
  {"DRVADD","Add a driver",		/* Add a driver to driver list	    */
    drvadd, STRING, HEX, HEX },
  {"DRVDEL","Delete a driver",		/* Delete a driver from driver list */
    drvdel, STRING, NOPARM, NOPARM },
  {"DRVPARM","Set Driver parameters",	/* Set Driver parameters	    */
    drvparms, STRING, NOPARM, NOPARM },
  {"DP",NULL,				/* Alternate to drvparm		    */
    drvparms, STRING, NOPARM, NOPARM },
  {"DUMP","Dump Log block(s)",		/* Dump log block(s)		    */
    dump, DEC, DEC, NOPARM },
  {"GETDATA", NULL,			/* Get all data since last getdata  */
    getdata, NOPARM, NOPARM, NOPARM },	/* This is for automatic (850) usage*/
  {"GETLOG","Get Log Data",		/* Get specific log records	    */
    getlog, DEC, DEC, DEC },		/* This is for users		    */
  {"H","Help (also ?)",			/* Print Help Message		    */
    help, NOPARM, NOPARM, NOPARM },
  {"LOAD","Load Bytes",			/* Load Bytes			    */
    load, NOPARM, NOPARM, NOPARM },
  {"LOGS","Get logged records",		/* Get log record numbers	    */
    getlognmbrs, NOPARM, NOPARM, NOPARM },
  {"PARM","Show/set user parameters",	/* Get/Set User parameters	    */
    params, STRING, STRING, NOPARM },
  {"POWER","Get/Set power vector",	/* Get/Set power vector		    */
    usr_power, HEX, NOPARM, NOPARM },
  {"QUIT","Quit",			/* Quit				    */
    quit, NOPARM, NOPARM, NOPARM },
  {"Q",NULL,				/* Alternate Quit		    */
    quit, NOPARM, NOPARM, NOPARM },
  {"RESET","Reset System",		/* Reset System or Log memory	    */
    reset, STRING, DEC, NOPARM },
  {"S",	"Set Memory",			/* Set Memory			    */
    set, HEX, DEC, NOPARM },
#ifdef INCLUDE_SHUTCAL
  {"SHUTCAL","Shutter calibration",	/* Shutter calibration (local)	    */
    shutCal, STRING, NOPARM, NOPARM },
#endif
  {"STRING","Set string parameter",	/* Set string parameter		    */
    set_string, STRING, ALL, NOPARM },
  {"TIME","Get or Set Time & Date",	/* Get/Set Time			    */
    time, ALL, NOPARM, NOPARM },
#ifdef TNC
  {"TNC","Send command to remote radio", /* Send cmd strng to radio  */
    tnc_cmd, ALL, NOPARM, NOPARM },
  {"***", NULL,				/* Message from radio		    */
    radiomsg, ALL, NOPARM, NOPARM },
#endif
  {"?", NULL,				/* Print Help Message		    */
    help, NOPARM, NOPARM, NOPARM }
};					/************************************/
