/************************************************************************/
/* Copyright 2000 MBARI                                                 */
/************************************************************************/
/* $Header: tinyshut.h,v 4.4 2001/06/19 12:16:03 oasisa Exp $                   */
/* Summary  : Minimal Shutter defs and types for the OASIS mooring controller   */
/* Filename : tinyshut.h                                                  */
/* Author   : Kent Headley klh                                          */
/* Project  : OASIS Mooring                                             */
/* $Revision: 4.4 $                                                     */
/* Created  : 10:00 am 8/2/00                                           */
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:                                                */
/************************************************************************/

#ifndef INC_TINYSHUT_H
#define INC_TINYSHUT_H

#ifdef SHUTTER
#define NUMBER_OF_SHUTTERS	SHUTTER
#endif

/************************************************************************/
/* drv_parm    : PARM0 is shutter number                                */
/* usage       : PARM1 is closed position calibration                   */ 
/*             : PARM2 is number of attempts to complete operation      */
/*             : TIMEOUT is seconds allowed for each attempt            */
/************************************************************************/

#define SHUTTER_OPEN_SECTOR     360     /* width of open sector */
#define SHUTTER_CLOSED_SECTOR   6       /* width of closed sector */
#define SHUTTER_POLL            2       /* ticks per sample of shutter position */
#define MAX_SHUT_FAILURES       11       /* after which we cease trying */

#define CCW                     FALSE   /* Counter clockwise shutter rotation */
#define CW                      TRUE    /* Clockwise shutter rotation */

typedef enum 
{
    OPEN, CLOSED, INTER
} State ;                       /* possible states of shutter */

typedef enum
{
    RUN, STOP, OVERLOAD
} Motor ;                       /* possible states of motor drive hardware */

typedef struct 
{
    MBool       Open;           /* operation type, TRUE = open */
    Nat16       ShutterNumber;  /* which one  */
    Nat16       ClosePosition;  /* the closed or reference position for this shutter */
    Nat16       TryCount;       /* attempt --counter */
    Nat16       MaxTicks;       /* timeout value for each attempt */
    Nat16       ErrCode;        /* success or failure of move */
} Shutter_data ;

typedef struct
{
    Nat16    ad_port;
    Nat16    control_bit;
    Nat16    dir_bit;
} shutter_const ;


/****************************************/
/* Function Declarations                */
/****************************************/


#define PORT_DIR	(shutter_io[(sd)->ShutterNumber].dir_bit)
#define PORT_CTL        (shutter_io[(sd)->ShutterNumber].control_bit)
#define PORT_DIR_CTL    (shutter_io[(sd)->ShutterNumber].control_bit|shutter_io[(sd)->ShutterNumber].dir_bit)

Void    initMotor( Shutter_data *sd );
Void    startMotor( Shutter_data *sd );
Void    stopMotor( Shutter_data *sd );
Void    setDirMotor( MBool clockwise,Shutter_data *sd );
State   sector(Shutter_data *sd);

/*
MBool   readMotor( Shutter_data *sd );
MBool   readDirMotor( Shutter_data *sd );
Nat16   readShutter(Shutter_data *sd);
*/

/*
#define initMotor(sd)		\
do{				\
piaa_pdc &= ~PORT_DIR_CTL;	\
piaa_ddrc |= PORT_DIR_CTL;	\
}while(0)

#define startMotor(sd)		\
do{				\
    piaa_pdc |= PORT_CTL;	\
    piaa_ddrc |= PORT_CTL;	\
    task_delay(2);		\
    piaa_ddrc &= ~PORT_CTL;	\
}while(0)

#define stopMotor(sd)		\
do{				\
    piaa_pdc &= ~PORT_CTL;	\
    piaa_ddrc |= PORT_CTL;	\
    task_delay(15);		\
}while(0)

#define sector(sd)  ((((sd)->ClosePosition-SHUTTER_OPEN_SECTOR/2 >= readShutter(sd) ) \
      || ( readShutter(sd) >= (sd)->ClosePosition+SHUTTER_OPEN_SECTOR/2))?CLOSED:((((sd)->ClosePosition-SHUTTER_OPEN_SECTOR/2 >= readShutter(sd) ) \
      || ( readShutter(sd) >= (sd)->ClosePosition+SHUTTER_OPEN_SECTOR/2))?OPEN:INTER))

*/

#define readMotor(sd)    (( piaa_pdc & ((shutter_io[(sd)->ShutterNumber].control_bit))) ? TRUE : FALSE)
#define readDirMotor(sd) (( piaa_pdc & ((shutter_io[(sd)->ShutterNumber].dir_bit))) ? CW : CCW)
#define reverseMotor(sd) (setDirMotor(!readDirMotor(sd),(sd)))
#define readShutter(sd)  (io_atod(shutter_io[(sd)->ShutterNumber].ad_port))

#endif

/* END shut22.h */
