/************************************************************************/
/* Copyright 1991 MBARI							*/
/************************************************************************/
/* $Header: task.h,v 4.4 2001/06/19 12:15:49 oasisa Exp $			*/
/* Summary  : Definitions for Multitasking library for 80C196		*/
/* Filename : task.h							*/
/* Author   : Robert Herlien (rah)					*/
/* Project  : OASIS Mooring						*/
/* $Revision: 4.4 $							*/
/* Created  : 06/05/91							*/
/*									    */
/* MBARI provides this documentation and code "as is", with no warranty,    */
/* express or implied, of its quality or consistency. It is provided without*/
/* support and without obligation on the part of the Monterey Bay Aquarium  */
/* Research Institute to assist in its use, correction, modification, or    */
/* enhancement. This information should not be published or distributed to  */
/* third parties without specific written permission from MBARI.            */
/*									    */
/************************************************************************/
/* Modification History:						*/
/* 05jun91 rah - created						*/
/* $Log:	task.h,v $
 * Revision 4.4  2001/06/19  12:15:49  12:15:49  oasisa (Oasis users)
 * New Repository; 6/19/2001 (klh)
 * 
 * Revision 1.1  2001/06/19  11:45:02  11:45:02  oasisa (Oasis users)
 * Initial revision
 * 
 * Revision 3.4  96/06/18  15:24:05  15:24:05  bobh (Bob Herlien)
 * June '96 deployment of M1
 * 
 * Revision 3.1  95/03/09  19:30:49  19:30:49  hebo (Bob Herlien)
 * March '95 Deployment of M1A
 * 
 * Revision 3.0  95/02/21  18:42:34  18:42:34  hebo (Bob Herlien)
 * February '95 Deployment
 * 
 * Revision 2.0  92/08/21  14:45:57  14:45:57  hebo (Bob Herlien)
 * August 1992 deployment
 * 
 * Revision 1.3  92/03/03  16:40:01  16:40:01  hebo (Bob Herlien 408-647-3748)
 * New defaults, restart check, perm power stuff, analog command
 * 
*/
/************************************************************************/
/* You must include types.h and oasis.h before this file		*/
/************************************************************************/

#ifndef INCtaskLibh
#define INCtaskLibh	1

#define STKSIZE		400		/* Default task stack size	    */


/****************************************/
/* Type definitions for Task Library	*/
/****************************************/

typedef struct task_desc TaskDesc;	/* Task Descriptor struct	    */
typedef struct semaphore Semaphore;	/* Semaphore struct		    */
typedef Semaphore 	*SemID;		/* Semaphore ID			    */
typedef void		(*FuncPtr)();	/* Function pointer		    */
typedef struct node	Node;		/* Node in linked list		    */

#define NULLTASK	((TaskDesc *)0)
#define NULLSEM		((SemID)0)
#define NULLFUNC	((FuncPtr)0)
#define NULLNODE	((Node *)0)

struct node				/************************************/
{					/* List Node structure		    */
    Node	*lst_next;		/* Pointer to next node		    */
    Node	*lst_prev;		/* Pointer to previous node	    */
};					/************************************/

typedef struct				/************************************/
{					/* LstHead STRUCTURE		    */
    Node	*lst_head;		/* Head of linked list of tasks	    */
    Node	*lst_tail;		/* Tail of linked list of tasks	    */
} LstHead;				/************************************/

struct semaphore			/************************************/
{					/* Semaphore STRUCTURE		    */
    LstHead	sem_list;		/* Linked list of waiting tasks	    */
    Int16	sem_cnt;		/* Semaphore count		    */
};					/************************************/

typedef enum				/************************************/
{					/* Task State type		    */
    RUNNING = 0,			/* The single running task	    */
    READY,				/* Ready, but not running	    */
    PENDING,				/* Pending on a semaphore	    */
    DELAY				/* Waiting for delay()		    */
}TaskState;				/************************************/
    
struct task_desc			/************************************/
{					/* Task Descriptor STRUCTURE	    */
    TaskDesc	*td_next;		/* These two fields should be NODE, */
    TaskDesc	*td_prev;		/* but ratshit Intel linkr screws up*/
    char	*td_name;		/* Task name			    */
    SemID	td_sem;			/* Semaphore we're waiting on	    */
    Int16	td_delay;		/* Delay count			    */
    TaskState	td_state;		/* Task state			    */
    FuncPtr	*td_stack;		/* Base of task stack		    */
    FuncPtr	*td_sp;			/* Task current stack pointer	    */
    Driver	*td_drvr;		/* Driver ptr			    */
    Int16	td_serchar;		/* Last serial output char	    */
};					/************************************/


/****************************************/
/* Function Declarations		*/
/****************************************/

Void	 list_init( LstHead *lp );
Node	 *list_head( LstHead *lp );
Void	 list_add( LstHead *lp, Node *np );
Node	 *list_get( LstHead *lp, Node *np );
Node	 *list_first( LstHead *lp );
Node	 *list_next( Node *np );
TaskDesc *task_init( Void );
TaskDesc *task_get( Void );
Void	 task_exit( Void );
Void	 task_delay( Int16 count );
Void	 delay_secs( Nat16 secs );
Void	 dispatch( Void );
Void	 sem_init( SemID sem, Int16 count );
Void	 sem_take( Reg SemID sem );
Void	 sem_give( Reg SemID sem );

#endif	/* INCtaskLibh */
